/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import com.teamresourceful.resourcefullib.common.fluid.data.FluidData;
import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluid;
import com.telepathicgrunt.the_bumblezone.fluids.base.FluidGetter;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;

public class HoneyFluidBlock
extends LiquidBlock
implements FluidGetter {
    public static final int maxBottomLayer = 8;
    public static final IntegerProperty BOTTOM_LEVEL = IntegerProperty.create((String)"bottom_level", (int)0, (int)8);
    public static final BooleanProperty ABOVE_FLUID = BooleanProperty.create((String)"above_support");

    public HoneyFluidBlock(FluidData baseFluid) {
        super((FlowingFluid)baseFluid.still().get(), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).liquid().noCollission().strength(100.0f, 100.0f).speedFactor(0.15f).noLootTable().replaceable().sound(SoundType.EMPTY).pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)BOTTOM_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)FlowingFluid.FALLING, (Comparable)Boolean.valueOf(false))).setValue((Property)ABOVE_FLUID, (Comparable)Boolean.valueOf(false)));
        baseFluid.setBlock(() -> this);
    }

    @Override
    public FlowingFluid getFluid() {
        return this.fluid;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{LEVEL, BOTTOM_LEVEL, FlowingFluid.FALLING, ABOVE_FLUID});
    }

    public void neighborChanged(BlockState blockState, Level world, BlockPos blockPos, Block block, BlockPos fromPos, boolean notify) {
        if (this.neighboringFluidInteractions(world, blockPos)) {
            world.scheduleTick(blockPos, blockState.getFluidState().getType(), HoneyFluid.adjustedFlowSpeed(this.getFluid().getTickDelay((LevelReader)world), (LevelAccessor)world, blockPos));
        }
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState previousBlockState, LevelAccessor level, BlockPos blockPos, BlockPos blockPos1) {
        if (blockState.getFluidState().isSource() || previousBlockState.getFluidState().isSource()) {
            level.scheduleTick(blockPos, blockState.getFluidState().getType(), HoneyFluid.adjustedFlowSpeed(this.getFluid().getTickDelay((LevelReader)level), level, blockPos));
        }
        return super.updateShape(blockState, direction, previousBlockState, level, blockPos, blockPos1);
    }

    public void onPlace(BlockState blockState, Level world, BlockPos blockPos, BlockState previousBlockState, boolean notify) {
        if (this.neighboringFluidInteractions(world, blockPos)) {
            world.scheduleTick(blockPos, blockState.getFluidState().getType(), HoneyFluid.adjustedFlowSpeed(this.getFluid().getTickDelay((LevelReader)world), (LevelAccessor)world, blockPos));
        }
    }

    private boolean neighboringFluidInteractions(Level world, BlockPos pos) {
        boolean lavaflag = false;
        boolean lavadownflag = false;
        for (Direction direction : Direction.values()) {
            BlockPos sidePos = pos.relative(direction);
            FluidState sideFluid = world.getFluidState(sidePos);
            if (sideFluid.is(FluidTags.LAVA)) {
                lavaflag = true;
                if (direction != Direction.DOWN) break;
                lavadownflag = true;
                break;
            }
            if (sideFluid.isEmpty() || sideFluid.is(BzTags.HONEY_FLUID)) continue;
            FluidState currentFluid = world.getFluidState(pos);
            if (direction == Direction.DOWN && currentFluid.hasProperty((Property)BOTTOM_LEVEL) && (Integer)currentFluid.getValue((Property)BOTTOM_LEVEL) != 0) continue;
            if (direction == Direction.UP) {
                world.setBlock(pos, ((Block)BzBlocks.GLISTERING_HONEY_CRYSTAL.get()).defaultBlockState(), 3);
                return false;
            }
            BlockState sideState = world.getBlockState(sidePos);
            if (sideState.getBlock() instanceof LiquidBlock || !sideState.getFluidState().isEmpty() || sideState.canBeReplaced()) {
                world.setBlock(sidePos, ((Block)BzBlocks.GLISTERING_HONEY_CRYSTAL.get()).defaultBlockState(), 3);
                continue;
            }
            if (currentFluid.isSource()) continue;
            world.setBlock(pos, ((Block)BzBlocks.GLISTERING_HONEY_CRYSTAL.get()).defaultBlockState(), 3);
            return false;
        }
        if (lavaflag) {
            BlockState moddedResultBlockState;
            FluidState currentFluid = world.getFluidState(pos);
            if (currentFluid.isSource()) {
                BlockState resultBlockState = ((Block)BzBlocks.SUGAR_INFUSED_STONE.get()).defaultBlockState();
                for (ModCompat compat : ModChecker.HONEY_FLUID_LAVA_INTERACTION_COMPATS) {
                    moddedResultBlockState = compat.honeyLavaResultBlock(currentFluid);
                    if (moddedResultBlockState == null) continue;
                    resultBlockState = moddedResultBlockState;
                }
                world.setBlockAndUpdate(pos, resultBlockState);
                this.triggerMixEffects(world, pos);
                return false;
            }
            if (!lavadownflag || currentFluid.hasProperty((Property)BOTTOM_LEVEL) && (Integer)currentFluid.getValue((Property)BOTTOM_LEVEL) == 0) {
                BlockState resultBlockState = ((Block)BzBlocks.SUGAR_INFUSED_COBBLESTONE.get()).defaultBlockState();
                for (ModCompat compat : ModChecker.HONEY_FLUID_LAVA_INTERACTION_COMPATS) {
                    moddedResultBlockState = compat.honeyLavaResultBlock(currentFluid);
                    if (moddedResultBlockState == null) continue;
                    resultBlockState = moddedResultBlockState;
                }
                world.setBlockAndUpdate(pos, resultBlockState);
                this.triggerMixEffects(world, pos);
                return false;
            }
        }
        return true;
    }

    public FluidState getFluidState(BlockState blockState) {
        int fluidLevel = Math.min(Math.max((Integer)blockState.getValue((Property)LEVEL), 0), 8);
        int bottomFluidLevel = Math.min(Math.max((Integer)blockState.getValue((Property)BOTTOM_LEVEL), 0), 8);
        boolean isFalling = (Boolean)blockState.getValue((Property)FlowingFluid.FALLING);
        FluidState fluidState = fluidLevel == 0 ? this.getFluid().getSource(false) : (FluidState)this.getFluid().getFlowing(fluidLevel, isFalling).setValue((Property)BOTTOM_LEVEL, (Comparable)Integer.valueOf(bottomFluidLevel));
        return (FluidState)fluidState.setValue((Property)ABOVE_FLUID, (Comparable)((Boolean)blockState.getValue((Property)ABOVE_FLUID)));
    }

    public void entityInside(BlockState state, Level world, BlockPos position, Entity entity) {
        ServerPlayer serverPlayer;
        Bee beeEntity;
        double verticalSpeedDeltaLimit = 0.01;
        if (entity instanceof Bee && !(beeEntity = (Bee)entity).isDeadOrDying()) {
            if (beeEntity.getHealth() < beeEntity.getMaxHealth() && PlatformService.INSTANCE.isEyesInNoFluid(entity)) {
                float diff = beeEntity.getMaxHealth() - beeEntity.getHealth();
                beeEntity.heal(diff);
                BlockState currentState = world.getBlockState(position);
                if (currentState.is((Block)BzFluids.HONEY_FLUID_BLOCK.get())) {
                    world.setBlock(position, (BlockState)currentState.setValue((Property)LEVEL, (Comparable)Integer.valueOf(Math.max((Integer)currentState.getValue((Property)LEVEL) - (int)Math.ceil(diff), 1))), 3);
                }
            }
        } else if (Math.abs(entity.getDeltaMovement().y()) > verticalSpeedDeltaLimit && (double)entity.fallDistance <= 0.2) {
            Vec3 vec3 = entity.getDeltaMovement();
            entity.setDeltaMovement(new Vec3(vec3.x(), Math.copySign(verticalSpeedDeltaLimit, vec3.y()), vec3.z()));
        }
        if (entity instanceof ServerPlayer && EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)entity)) {
            serverPlayer.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 20, 0, false, false, true));
        }
        super.entityInside(state, world, position, entity);
    }

    private void triggerMixEffects(Level world, BlockPos pos) {
        world.levelEvent(1501, pos, 0);
    }
}

