/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.effects;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.mixin.effects.MobEffectInstanceAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MobEffectClientSyncPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ParalyzedEffect
extends MobEffect {
    public ParalyzedEffect(MobEffectCategory type, int potionColor) {
        super(type, potionColor);
    }

    public boolean isInstantenous() {
        return false;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration >= 1;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        return !livingEntity.getType().is(EntityTypeTags.UNDEAD) && !livingEntity.getType().is(BzTags.PARALYZED_IMMUNE);
    }

    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effect = livingEntity.getEffect(BzEffects.PARALYZED.holder());
        if (effect == null) {
            return;
        }
        if (effect.getDuration() > BzGeneralConfigs.paralyzedMaxTickDuration) {
            ((MobEffectInstanceAccessor)effect).bumblezone$setDuration(BzGeneralConfigs.paralyzedMaxTickDuration);
        }
        if (!livingEntity.isRemoved() && livingEntity.level() instanceof ServerLevel) {
            MobEffectClientSyncPacket.sendToClient((Entity)livingEntity, effect);
        }
        super.onEffectStarted(livingEntity, amplifier);
    }

    public static void effectRemoval(LivingEntity entity, MobEffectInstance mobEffectInstance) {
        if (entity.level().isClientSide || mobEffectInstance.getEffect() != BzEffects.PARALYZED.holder()) {
            return;
        }
        MobEffectClientSyncPacket.sendToClient((Entity)entity, new MobEffectInstance(BzEffects.PARALYZED.holder(), 0, mobEffectInstance.getAmplifier(), false, true, true));
    }

    public static boolean isParalyzed(LivingEntity livingEntity) {
        Player player;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).isCreative() || player.isSpectator())) {
            return false;
        }
        return livingEntity.hasEffect(BzEffects.PARALYZED.holder());
    }

    public static boolean isParalyzedClient(LivingEntity livingEntity) {
        Player player;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).isCreative() || player.isSpectator())) {
            return false;
        }
        MobEffectInstance effect = livingEntity.getEffect(BzEffects.PARALYZED.holder());
        if (effect != null) {
            if (effect.getDuration() <= 0) {
                livingEntity.removeEffect(BzEffects.PARALYZED.holder());
            }
            return true;
        }
        return false;
    }
}

