/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.ElectricRingEntity;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EssenceBlockYellow
extends EssenceBlock {
    public static final MapCodec<EssenceBlockYellow> CODEC = Block.simpleCodec(EssenceBlockYellow::new);
    private static final int RINGS_TO_PASS = 100;

    public EssenceBlockYellow() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).strength(-1.0f, 3600000.8f).lightLevel(blockState -> 15).noLootTable().forceSolidOn().isValidSpawn((blockState, blockGetter, blockPos, entityType) -> false).isViewBlocking((blockState, blockGetter, blockPos) -> false).pushReaction(PushReaction.BLOCK));
    }

    public EssenceBlockYellow(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends EssenceBlockYellow> codec() {
        return CODEC;
    }

    @Override
    public ResourceLocation getArenaNbt() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence/yellow_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return BzGeneralConfigs.yellowArenaTimeFrameInTicks;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.yellow_essence_event", BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    }

    @Override
    public ResourceLocation getEssenceItemReward() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"gameplay/rewards/yellow_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(ServerPlayer serverPlayer) {
        serverPlayer.awardStat((ResourceLocation)BzStats.RADIANCE_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().isEmpty()) {
            return;
        }
        int ringsPassed = essenceBlockEntity.getExtraEventTrackingProgress();
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        int ringsActive = 0;
        for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
            Vex vex;
            UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
            Entity entity = serverLevel.getEntity(entityToCheck);
            if (entity == null) {
                List nearbyRings = serverLevel.getEntitiesOfClass(ElectricRingEntity.class, new AABB((double)((float)blockPos.getX() - (float)essenceBlockEntity.getArenaSize().getX() * 0.5f), (double)((float)blockPos.getY() - (float)essenceBlockEntity.getArenaSize().getY() * 0.5f), (double)((float)blockPos.getZ() - (float)essenceBlockEntity.getArenaSize().getZ() * 0.5f), (double)((float)blockPos.getX() + (float)essenceBlockEntity.getArenaSize().getX() * 0.5f), (double)((float)blockPos.getY() + (float)essenceBlockEntity.getArenaSize().getY() * 0.5f), (double)((float)blockPos.getZ() + (float)essenceBlockEntity.getArenaSize().getZ() * 0.5f)));
                for (ElectricRingEntity nearbyRing : nearbyRings) {
                    if (!nearbyRing.getUUID().equals(entityToCheck) || !nearbyRing.getEssenceController().equals(essenceBlockEntity.getUUID())) continue;
                    entity = nearbyRing;
                    break;
                }
            }
            if (entity == null) {
                eventEntitiesInArena.remove(i);
                continue;
            }
            if (entity instanceof ElectricRingEntity) {
                ElectricRingEntity electricRingEntity = (ElectricRingEntity)entity;
                electricRingEntity.setEssenceController(essenceBlockEntity.getUUID());
                electricRingEntity.setEssenceControllerBlockPos(essenceBlockEntity.getBlockPos());
                electricRingEntity.setEssenceControllerDimension((ResourceKey<Level>)serverLevel.dimension());
                ++ringsActive;
                continue;
            }
            if (!(entity instanceof Vex) || (vex = (Vex)entity).getTarget() == null || vex.tickCount % 20 != 0) continue;
            Vec3 targetDirection = vex.getTarget().position().subtract(vex.position()).normalize();
            if (vex.isCharging()) {
                vex.addDeltaMovement(targetDirection.scale(0.3));
            }
            if (vex.getRandom().nextInt(15) != 0) continue;
            vex.getMoveControl().setWantedPosition(vex.getX(), vex.getY(), vex.getZ(), 1.0);
        }
        if (ringsPassed != 100 && ringsActive == 0) {
            EssenceBlockYellow.spawnNewRing(serverLevel, blockPos, essenceBlockEntity, ringsPassed, eventEntitiesInArena);
            if (ringsPassed >= 2) {
                EssenceBlockYellow.spawnNewEnemy(serverLevel, blockPos, essenceBlockEntity, eventEntitiesInArena);
            }
        }
        float newProgress = (float)ringsPassed / 100.0f;
        essenceBlockEntity.getEventBar().setProgress(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(ringsPassed);
        if (ringsPassed == 100) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
    }

    private static void spawnNewRing(ServerLevel serverLevel, BlockPos blockPos, EssenceBlockEntity essenceBlockEntity, int currentRingsPassed, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        BlockPos arenaSize = essenceBlockEntity.getArenaSize();
        RandomSource random = serverLevel.getRandom();
        int x = arenaSize.getX() / 2 - 5;
        int y = -(arenaSize.getY() / 2) + 1;
        int z = arenaSize.getZ() / 2 - 5;
        if ((float)currentRingsPassed / 100.0f >= 0.5f) {
            float randomChosen = random.nextFloat();
            randomChosen = (double)randomChosen < 0.3 ? 0.0f : (randomChosen * 0.4f + 0.55f) * ((float)currentRingsPassed * 12.0f / 100.0f);
            y = (int)Math.min((float)y + randomChosen, (float)arenaSize.getY() / 2.0f - 3.0f);
        } else {
            y = (int)Math.min((float)y + random.nextFloat() * ((float)currentRingsPassed * 12.0f / 100.0f), (float)arenaSize.getY() / 2.0f - 3.0f);
        }
        switch (currentRingsPassed % 4) {
            case 0: {
                x = (int)((float)x * random.nextFloat() + 2.0f);
                z = (int)((float)z * random.nextFloat() + 2.0f);
                break;
            }
            case 1: {
                x = (int)((float)x * random.nextFloat() + 2.0f);
                z = (int)((float)z * random.nextFloat() + 2.0f) * -1;
                break;
            }
            case 2: {
                x = (int)((float)x * random.nextFloat() + 2.0f) * -1;
                z = (int)((float)z * random.nextFloat() + 2.0f) * -1;
                break;
            }
            case 3: {
                x = (int)((float)x * random.nextFloat() + 2.0f) * -1;
                z = (int)((float)z * random.nextFloat() + 2.0f);
            }
        }
        Vec3 centerOfRing = new Vec3((double)(blockPos.getX() + x), (double)(blockPos.getY() + y), (double)(blockPos.getZ() + z));
        Vec3 centerOfEssence = essenceBlockEntity.getBlockPos().getCenter();
        centerOfEssence = new Vec3(centerOfEssence.x(), 0.0, centerOfEssence.z());
        Vec3 vectorFromEssence = centerOfEssence.subtract(centerOfRing).add(0.0, centerOfRing.y(), 0.0).normalize();
        double angle = Mth.atan2((double)(-vectorFromEssence.x()), (double)vectorFromEssence.z()) + 1.5707963705062866;
        if (angle < 0.0) {
            angle += 3.1415927410125732;
        }
        angle *= 57.2957763671875;
        ElectricRingEntity ringEntity = (ElectricRingEntity)((EntityType)BzEntities.ELECTRIC_RING_ENTITY.get()).create((Level)serverLevel);
        if (ringEntity != null) {
            ringEntity.addTag("the_bumblezone.yellow_essence_arena");
            ringEntity.setYRot((float)angle);
            if (y > 0) {
                ringEntity.setXRot(90.0f);
            } else if (y > -3) {
                ringEntity.setXRot(45.0f);
            }
            ringEntity.setPos(centerOfRing.x, centerOfRing.y, centerOfRing.z);
            ringEntity.setOldPosAndRot();
            ringEntity.setEssenceController(essenceBlockEntity.getUUID());
            ringEntity.setEssenceControllerBlockPos(essenceBlockEntity.getBlockPos());
            ringEntity.setEssenceControllerDimension((ResourceKey<Level>)serverLevel.dimension());
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(ringEntity.getUUID()));
            serverLevel.addFreshEntityWithPassengers((Entity)ringEntity);
        }
    }

    private static void spawnNewEnemy(ServerLevel serverLevel, BlockPos blockPos, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        int yOffset;
        TagKey<EntityType<?>> enemyTagToUse = BzTags.ESSENCE_RADIANCE_ARENA_NORMAL_ENEMY;
        List entityTypeList = BuiltInRegistries.ENTITY_TYPE.getTag(enemyTagToUse).map(holders -> holders.stream().map(Holder::value).toList()).orElseGet(ArrayList::new);
        EntityType entityTypeToSpawn = (EntityType)entityTypeList.get(serverLevel.getRandom().nextInt(entityTypeList.size()));
        Entity entity = entityTypeToSpawn.spawn(serverLevel, blockPos.offset(0, yOffset = (essenceBlockEntity.getArenaSize().getY() - 2) / 2, 0), MobSpawnType.TRIGGERED);
        if (entity != null) {
            entity.addTag("the_bumblezone.yellow_essence_arena");
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.getUUID()));
            UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.getRandom().nextInt(essenceBlockEntity.getPlayerInArena().size()));
            ServerPlayer player = serverLevel.getServer().getPlayerList().getPlayer(playerUUID);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                float maxHeart = Math.max(serverPlayer.getHealth(), serverPlayer.getMaxHealth());
                float maxArmor = serverPlayer.getArmorValue();
                float mobHealthBoost = maxHeart / 10.0f + maxArmor / 2.0f;
                float mobAttackBoost = Math.max(maxHeart / 40.0f + maxArmor / 3.0f - 3.5f, 0.0f);
                boolean isEssenced = EssenceOfTheBees.hasEssence(serverPlayer);
                if (!isEssenced) {
                    mobHealthBoost *= 1.5f;
                    mobAttackBoost *= 1.5f;
                }
                if (entity instanceof LivingEntity) {
                    AttributeInstance livingEntityAttributeFollowRange;
                    AttributeInstance livingEntityAttributeFlyingSpeed;
                    AttributeInstance livingEntityAttributeSpeed;
                    AttributeInstance livingEntityAttributeKnockback;
                    AttributeInstance livingEntityAttributeAttack;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    AttributeInstance livingEntityAttributeHealth = livingEntity.getAttribute(Attributes.MAX_HEALTH);
                    if (livingEntityAttributeHealth != null) {
                        livingEntityAttributeHealth.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_health_boost"), (double)mobHealthBoost, AttributeModifier.Operation.ADD_VALUE));
                        livingEntity.heal(mobHealthBoost);
                    }
                    if ((livingEntityAttributeAttack = livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
                        livingEntityAttributeAttack.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_damage_boost"), (double)mobAttackBoost, AttributeModifier.Operation.ADD_VALUE));
                    }
                    if ((livingEntityAttributeKnockback = livingEntity.getAttribute(Attributes.ATTACK_KNOCKBACK)) != null) {
                        livingEntityAttributeKnockback.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_knockback_boost"), isEssenced ? 0.3 : 0.6, AttributeModifier.Operation.ADD_VALUE));
                    }
                    if ((livingEntityAttributeSpeed = livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
                        livingEntityAttributeSpeed.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_speed_boost"), isEssenced ? 0.065 : 0.085, AttributeModifier.Operation.ADD_VALUE));
                    }
                    if ((livingEntityAttributeFlyingSpeed = livingEntity.getAttribute(Attributes.FLYING_SPEED)) != null) {
                        livingEntityAttributeFlyingSpeed.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_flying_speed_boost"), isEssenced ? 0.065 : 0.085, AttributeModifier.Operation.ADD_VALUE));
                    }
                    if ((livingEntityAttributeFollowRange = livingEntity.getAttribute(Attributes.FOLLOW_RANGE)) != null) {
                        livingEntityAttributeFollowRange.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_sight_boost"), 32.0, AttributeModifier.Operation.ADD_VALUE));
                    }
                }
                if (entity instanceof NeutralMob) {
                    NeutralMob neutralMob = (NeutralMob)entity;
                    neutralMob.setRemainingPersistentAngerTime(Integer.MAX_VALUE);
                    neutralMob.setPersistentAngerTarget(playerUUID);
                    neutralMob.setTarget((LivingEntity)serverPlayer);
                } else if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.setTarget((LivingEntity)serverPlayer);
                    if (entity instanceof Rabbit) {
                        Rabbit rabbit = (Rabbit)entity;
                        rabbit.setVariant(Rabbit.Variant.EVIL);
                    }
                }
                if (entity instanceof Vex) {
                    Vex vex = (Vex)entity;
                    if (eventEntitiesInArena.size() > 25) {
                        vex.setSilent(true);
                    }
                }
            }
        }
    }

    @Override
    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.RADIANCE_EVENT.get()).getLocation(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.RADIANCE_EVENT.get()).getLocation(), false);
        EssenceBlockYellow.removeBonusEffectsFromPlayer(serverPlayer);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }

    public void ringActivated(ElectricRingEntity electricRingEntity, EssenceBlockEntity essenceBlockEntity, ServerPlayer serverPlayer) {
        int ringsPassed = essenceBlockEntity.getExtraEventTrackingProgress();
        essenceBlockEntity.getEventEntitiesInArena().removeIf(e -> e.uuid().equals(electricRingEntity.getUUID()));
        if (ringsPassed + 1 >= 100) {
            EssenceBlockYellow.removeBonusEffectsFromPlayer(serverPlayer);
        } else if (EssenceOfTheBees.hasEssence(serverPlayer)) {
            serverPlayer.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, essenceBlockEntity.getEventTimer(), ringsPassed / 7, false, false));
            serverPlayer.addEffect(new MobEffectInstance(MobEffects.JUMP, essenceBlockEntity.getEventTimer(), Math.min(ringsPassed / 7, 8), false, false));
        }
        float newProgress = (float)(++ringsPassed) / 100.0f;
        essenceBlockEntity.getEventBar().setProgress(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(ringsPassed);
    }

    private static void removeBonusEffectsFromPlayer(ServerPlayer serverPlayer) {
        if (serverPlayer.hasEffect(MobEffects.JUMP)) {
            serverPlayer.removeEffect(MobEffects.JUMP);
        }
        if (serverPlayer.hasEffect(MobEffects.MOVEMENT_SPEED)) {
            serverPlayer.removeEffect(MobEffects.MOVEMENT_SPEED);
        }
    }
}

