/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.gravelminer;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.Comment;
import net.blay09.mods.balm.api.config.Config;
import net.blay09.mods.balm.api.config.ExpectedType;
import net.blay09.mods.gravelminer.GravelMinerActivation;

@Config(value="gravelminer")
public class GravelMinerConfigData
implements BalmConfigData {
    public Common common = new Common();
    public Client client = new Client();

    public static class Common {
        @ExpectedType(value=String.class)
        @Comment(value="Blocks that will fall and break into items when hitting a non-solid block. Format: modid:name")
        public List<String> gravelBlocks = Lists.newArrayList((Object[])new String[]{"minecraft:gravel"});
        @Comment(value="If set to true, the mod will trigger when mining gravel as well, instead of only when mining a non-gravel block below gravel.")
        public boolean triggerOnGravel = true;
        @Comment(value="If set to true, GravelMiner will only be active for users who install the mod on their clients (for use in servers).")
        public boolean isOptIn = true;
        @Comment(value="If set to true, gravel mined via GravelMiner will have a chance of dropping as flint (server-side only).")
        public boolean rollFlintChance = true;
    }

    public static class Client {
        @Comment(value="Whether GravelMiner is currently enabled for this client (toggled via keybind)")
        public boolean isEnabled = true;
        @Comment(value="Defines when GravelMiner should activate. Either ALWAYS, WHEN_SNEAKING or WHEN_NOT_SNEAKING")
        public GravelMinerActivation activation = GravelMinerActivation.ALWAYS;
    }
}

