/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.gravelminer;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.gravelminer.GravelMiner;
import net.blay09.mods.gravelminer.GravelMinerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class BlockBreakHandler {
    public static void blockBroken(BreakBlockEvent event) {
        int startY;
        Player player = event.getPlayer();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        if (Balm.getHooks().isFakePlayer(player) || !GravelMiner.isEnabledFor(player)) {
            return;
        }
        if (!GravelMinerConfig.getActive().common.triggerOnGravel && GravelMiner.isGravelBlock(state)) {
            return;
        }
        int maxCount = 256;
        for (int y = startY = pos.getY() + 1; y <= startY + 256; ++y) {
            BlockPos posAbove = new BlockPos(pos.getX(), y, pos.getZ());
            BlockState stateAbove = level.getBlockState(posAbove);
            if (!GravelMiner.isGravelBlock(stateAbove)) {
                return;
            }
            BlockBreakHandler.playBreakBlockEffects(level, posAbove, stateAbove);
            if (BlockBreakHandler.breakBlock(player, level, posAbove, stateAbove)) continue;
            return;
        }
    }

    private static void playBreakBlockEffects(Level level, BlockPos pos, BlockState state) {
        int blockBreakEvent = 2001;
        level.levelEvent(null, 2001, pos, Block.getId((BlockState)state));
    }

    private static boolean breakBlock(Player player, Level level, BlockPos pos, BlockState state) {
        FluidState fluidState = level.getFluidState(pos);
        state.getBlock().playerWillDestroy(level, pos, state, player);
        boolean removedByPlayer = level.setBlock(pos, fluidState.createLegacyBlock(), level.isClientSide ? 11 : 3);
        if (!removedByPlayer) {
            return false;
        }
        if (!player.getAbilities().instabuild) {
            state.getBlock().destroy((LevelAccessor)level, pos, state);
            if (GravelMinerConfig.getActive().common.rollFlintChance || state.getBlock() != Blocks.GRAVEL) {
                state.getBlock().playerDestroy(level, player, pos, state, level.getBlockEntity(pos), ItemStack.EMPTY);
            } else {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Blocks.GRAVEL, 1));
            }
        }
        return true;
    }
}

