/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.utils;

import com.stevekung.fishofthieves.mixin.accessor.PointedDripstoneBlockAccessor;
import com.stevekung.fishofthieves.registry.FOTCriteriaTriggers;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public class CauldronUtils {
    private static final Predicate<BlockState> IS_CAULDRON = blockState -> blockState.getBlock() instanceof AbstractCauldronBlock;

    public static void fillCauldronFromLeavesTail(BlockState state, ServerLevel level, BlockPos pos) {
        Optional<BlockPos> optional = CauldronUtils.findFillableCauldronBelowLeavesTail((Level)level, pos);
        if (optional.isPresent()) {
            BlockPos blockPos2 = optional.get();
            BlockState blockState2 = level.getBlockState(blockPos2);
            boolean trigger = false;
            if (blockState2.getBlock() != Blocks.WATER_CAULDRON) {
                blockState = Blocks.WATER_CAULDRON.defaultBlockState();
                level.setBlockAndUpdate(blockPos2, blockState);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos2, GameEvent.Context.of((BlockState)blockState));
                level.levelEvent(1047, blockPos2, 0);
                trigger = true;
            } else if (!((LayeredCauldronBlock)blockState2.getBlock()).isFull(blockState2)) {
                blockState = (BlockState)blockState2.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)blockState2.getValue((Property)LayeredCauldronBlock.LEVEL) + 1));
                level.setBlockAndUpdate(blockPos2, blockState);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos2, GameEvent.Context.of((BlockState)blockState));
                level.levelEvent(1047, blockPos2, 0);
                trigger = true;
            }
            if (trigger) {
                for (ServerPlayer serverPlayer : level.getNearbyPlayers(TargetingConditions.forNonCombat(), null, new AABB(pos).inflate(8.0)).stream().map(ServerPlayer.class::cast).toList()) {
                    FOTCriteriaTriggers.WATER_DRIP_ON_BLOCK.trigger(level, pos, serverPlayer, state);
                }
            }
        }
    }

    public static Optional<BlockPos> findFillableCauldronBelowLeavesTail(Level level, BlockPos pos) {
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> PointedDripstoneBlockAccessor.invokeCanDripThrough((BlockGetter)level, blockPos, blockState);
        return PointedDripstoneBlockAccessor.invokeFindBlockVertical((LevelAccessor)level, pos, Direction.DOWN.getAxisDirection(), biPredicate, IS_CAULDRON, 11);
    }
}

