/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.trigger;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTCriteriaTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class FollowLivingWithEffectTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Entity sourceEntity) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(player, sourceEntity));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<EntityPredicate> sourceEntity, Optional<MobEffectsPredicate> effects) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.CODEC.optionalFieldOf("source_entity").forGetter(TriggerInstance::sourceEntity), (App)MobEffectsPredicate.CODEC.optionalFieldOf("effects").forGetter(TriggerInstance::effects)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> entityWithEffect(EntityPredicate.Builder entityPredicate, MobEffectsPredicate.Builder mobEffects) {
            return FOTCriteriaTriggers.FOLLOW_LIVING_WITH_EFFECT.createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(entityPredicate.build()), mobEffects.build()));
        }

        public boolean matches(ServerPlayer serverPlayer, Entity sourceEntity) {
            return !(!this.sourceEntity.isEmpty() && !this.sourceEntity.get().matches(serverPlayer, sourceEntity) || !this.effects.isEmpty() && !this.effects.get().matches((LivingEntity)serverPlayer));
        }
    }
}

