/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.structure;

import com.mojang.serialization.MapCodec;
import com.stevekung.fishofthieves.registry.FOTStructures;
import com.stevekung.fishofthieves.structure.SeapostPieces;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class SeapostStructure
extends Structure {
    public static final MapCodec<SeapostStructure> CODEC = SeapostStructure.simpleCodec(SeapostStructure::new);

    public SeapostStructure(Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return SeapostStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, structurePiecesBuilder -> this.generatePieces((StructurePiecesBuilder)structurePiecesBuilder, context));
    }

    private void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext generationContext) {
        Rotation rotation = Rotation.getRandom((RandomSource)generationContext.random());
        BlockPos blockPos = new BlockPos(generationContext.chunkPos().getMinBlockX(), generationContext.chunkGenerator().getSeaLevel() - 4, generationContext.chunkPos().getMinBlockZ());
        SeapostPieces.addPieces(generationContext.structureTemplateManager(), blockPos, rotation, (StructurePieceAccessor)structurePiecesBuilder);
    }

    public StructureType<?> type() {
        return FOTStructures.Type.SEAPOST;
    }
}

