/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTStructures;
import com.stevekung.fishofthieves.structure.GuardianFruitTreePiece;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class GuardianFruitTreeStructure
extends Structure {
    private static final String[] GUARDIAN_FRUIT_TREES = (String[])IntStream.rangeClosed(1, 5).mapToObj(value -> "guardian_fruit_tree_" + value).toArray(String[]::new);
    public static final MapCodec<GuardianFruitTreeStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("fruit_chance").forGetter(structure -> Float.valueOf(structure.fruitChance)), (App)GuardianFruitTreeStructure.settingsCodec((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, GuardianFruitTreeStructure::new));
    private final float fruitChance;

    public GuardianFruitTreeStructure(float fruitChance, Structure.StructureSettings settings) {
        super(settings);
        this.fruitChance = fruitChance;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        WorldgenRandom worldgenRandom = context.random();
        ResourceLocation resourceLocation = FishOfThieves.id(GUARDIAN_FRUIT_TREES[worldgenRandom.nextInt(GUARDIAN_FRUIT_TREES.length)]);
        StructureTemplate structureTemplate = context.structureTemplateManager().getOrCreate(resourceLocation);
        Rotation rotation = Rotation.getRandom((RandomSource)worldgenRandom);
        Mirror mirror = worldgenRandom.nextFloat() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
        BlockPos blockPos = new BlockPos(structureTemplate.getSize().getX() / 2, 0, structureTemplate.getSize().getZ() / 2);
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        RandomState randomState = context.randomState();
        BlockPos blockPos2 = context.chunkPos().getWorldPosition();
        BoundingBox boundingBox = structureTemplate.getBoundingBox(blockPos2, rotation, blockPos, mirror);
        BlockPos blockPos3 = boundingBox.getCenter();
        int height = chunkGenerator.getBaseHeight(blockPos3.getX(), blockPos3.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, levelHeightAccessor, randomState) - 1;
        int y = GuardianFruitTreeStructure.findSuitableY(chunkGenerator, height, boundingBox, levelHeightAccessor, randomState);
        BlockPos blockPos4 = new BlockPos(blockPos2.getX(), y, blockPos2.getZ());
        return Optional.of(new Structure.GenerationStub(blockPos4, structurePiecesBuilder -> structurePiecesBuilder.addPiece((StructurePiece)new GuardianFruitTreePiece(context.structureTemplateManager(), blockPos4, resourceLocation, rotation, mirror, blockPos, this.fruitChance))));
    }

    private static int findSuitableY(ChunkGenerator chunkGenerator, int height, BoundingBox box, LevelHeightAccessor level, RandomState randomState) {
        int l;
        int i = level.getMinBuildHeight() + 15;
        List<BlockPos> list = List.of(new BlockPos(box.minX(), 0, box.minZ()), new BlockPos(box.maxX(), 0, box.minZ()), new BlockPos(box.minX(), 0, box.maxZ()), new BlockPos(box.maxX(), 0, box.maxZ()));
        List<NoiseColumn> list2 = list.stream().map(blockPos -> chunkGenerator.getBaseColumn(blockPos.getX(), blockPos.getZ(), level, randomState)).toList();
        for (l = height; l > i; --l) {
            int m = 0;
            for (NoiseColumn noiseColumn : list2) {
                BlockState blockState = noiseColumn.getBlock(l);
                if (!Heightmap.Types.OCEAN_FLOOR_WG.isOpaque().test(blockState) || ++m != 3) continue;
                return l;
            }
        }
        return l;
    }

    public StructureType<?> type() {
        return FOTStructures.Type.GUARDIAN_FRUIT_TREE;
    }
}

