/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.storage;

import com.stevekung.fishofthieves.registry.FOTDataFixTypes;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public class BaitPreserveSavedData
extends SavedData {
    public static final String FILE_ID = "fishofthieves_bait_preserve";
    private static final String TAG_BAIT_PRESERVES = "bait_preserves";
    private final Map<Vec3, ItemStack> baitStorage;

    private BaitPreserveSavedData(Map<Vec3, ItemStack> baitStorage) {
        this.baitStorage = baitStorage;
    }

    public BaitPreserveSavedData() {
        this(new ConcurrentHashMap<Vec3, ItemStack>());
    }

    public static SavedData.Factory<BaitPreserveSavedData> factory() {
        return new SavedData.Factory(BaitPreserveSavedData::new, BaitPreserveSavedData::load, FOTDataFixTypes.SAVED_BAIT_PRESERVE);
    }

    public static BaitPreserveSavedData load(CompoundTag tag, HolderLookup.Provider provider) {
        ConcurrentHashMap<Vec3, ItemStack> baitStorage = new ConcurrentHashMap<Vec3, ItemStack>();
        ListTag listTag = tag.getList(TAG_BAIT_PRESERVES, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.getCompound(i);
            baitStorage.put(new Vec3(compoundTag.getDouble("x"), compoundTag.getDouble("y"), compoundTag.getDouble("z")), ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundTag.getCompound("item")).orElse(ItemStack.EMPTY));
        }
        return new BaitPreserveSavedData(baitStorage);
    }

    public void spawnBaitOnLoad(Level level) {
        Iterator<Map.Entry<Vec3, ItemStack>> iterator = this.baitStorage.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Vec3, ItemStack> entry = iterator.next();
            BlockPos blockPos = BlockPos.containing((Position)((Position)entry.getKey()));
            if (!level.isLoaded(blockPos)) continue;
            Vec3 vec3 = Vec3.atLowerCornerWithOffset((Vec3i)blockPos, (double)0.5, (double)0.25, (double)0.5).offsetRandom(level.random, 0.3f);
            ItemEntity itemEntity = new ItemEntity(level, vec3.x(), vec3.y(), vec3.z(), entry.getValue());
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
            iterator.remove();
            this.setDirty();
        }
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        if (!this.baitStorage.isEmpty()) {
            ListTag listTag = new ListTag();
            for (Map.Entry<Vec3, ItemStack> entry : this.baitStorage.entrySet()) {
                CompoundTag baitStorageTag = new CompoundTag();
                Vec3 pos = entry.getKey();
                baitStorageTag.put("item", entry.getValue().save(provider, (Tag)new CompoundTag()));
                baitStorageTag.putDouble("x", pos.x);
                baitStorageTag.putDouble("y", pos.y);
                baitStorageTag.putDouble("z", pos.z);
                listTag.add((Object)baitStorageTag);
            }
            compoundTag.put(TAG_BAIT_PRESERVES, (Tag)listTag);
        }
        return compoundTag;
    }

    public Map<Vec3, ItemStack> getBaitStorage() {
        return this.baitStorage;
    }
}

