/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.shoal;

import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.shoal.Shoal;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.shoal.ShoalChance;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public final class ShoalSpawner {
    private ShoalSpawner() {
    }

    @Nullable
    public static BlockPos spawn(ServerLevel level, int x, int z) {
        return ShoalSpawner.spawnShoalAtSuitablePos(level, level.getBlockRandomPos(x, level.getSeaLevel(), z, 0));
    }

    public static Optional<BlockPos> findFarthest(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int minimumDistance, int maximumDistance, PoiManager poiManager) {
        return ShoalSpawner.getInRange(typePredicate, pos, minimumDistance, maximumDistance, poiManager).map(PoiRecord::getPos).min(Comparator.comparingDouble(blockPos2 -> blockPos2.distSqr((Vec3i)pos)));
    }

    private static Stream<PoiRecord> getInRange(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int minimumDistance, int maximumDistance, PoiManager poiManager) {
        int minSum = minimumDistance * minimumDistance;
        int maxSum = maximumDistance * maximumDistance;
        return ShoalSpawner.getInSquare(typePredicate, pos, minimumDistance, maximumDistance, poiManager).filter(poiRecord -> {
            BlockPos blockPos = poiRecord.getPos();
            FishOfThieves.LOGGER.debug("minSum {} <= {}: {}", new Object[]{blockPos.distSqr((Vec3i)pos), minSum, blockPos.distSqr((Vec3i)pos) >= (double)minSum});
            FishOfThieves.LOGGER.debug("maxSum {} <= {}: {}", new Object[]{blockPos.distSqr((Vec3i)pos), maxSum, blockPos.distSqr((Vec3i)pos) <= (double)maxSum});
            return blockPos.distSqr((Vec3i)pos) >= (double)minSum && blockPos.distSqr((Vec3i)pos) <= (double)maxSum;
        });
    }

    private static Stream<PoiRecord> getInSquare(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int minimumDistance, int maximumDistance, PoiManager poiManager) {
        int chunkRadius = Math.floorDiv(maximumDistance, 16) + 1;
        return ChunkPos.rangeClosed((ChunkPos)new ChunkPos(pos), (int)chunkRadius).flatMap(chunkPos -> poiManager.getInChunk(typePredicate, chunkPos, PoiManager.Occupancy.ANY)).filter(poiRecord -> {
            BlockPos blockPos2 = poiRecord.getPos();
            FishOfThieves.LOGGER.debug("absX: {}", (Object)Math.abs(blockPos2.getX() - pos.getX()));
            FishOfThieves.LOGGER.debug("absZ: {}", (Object)Math.abs(blockPos2.getZ() - pos.getZ()));
            FishOfThieves.LOGGER.debug("minimumDistance: {}", (Object)minimumDistance);
            FishOfThieves.LOGGER.debug("maximumDistance: {}", (Object)maximumDistance);
            FishOfThieves.LOGGER.debug("logic minimumDistance: {}", (Object)(Math.abs(blockPos2.getX() - pos.getX()) >= minimumDistance && Math.abs(blockPos2.getZ() - pos.getZ()) >= minimumDistance ? 1 : 0));
            FishOfThieves.LOGGER.debug("logic maximumDistance: {}", (Object)(Math.abs(blockPos2.getX() - pos.getX()) <= maximumDistance && Math.abs(blockPos2.getZ() - pos.getZ()) <= maximumDistance ? 1 : 0));
            return Math.abs(blockPos2.getX() - pos.getX()) >= minimumDistance && Math.abs(blockPos2.getZ() - pos.getZ()) >= minimumDistance && Math.abs(blockPos2.getX() - pos.getX()) <= maximumDistance && Math.abs(blockPos2.getZ() - pos.getZ()) <= maximumDistance;
        });
    }

    public static BlockPos attemptSpawnShoal(ServerLevel serverLevel, BlockPos blockPos, int maxAttempt) {
        if (maxAttempt > 0) {
            ChunkPos chunkPos;
            BlockPos shoalPos = null;
            ChunkPos currentChunkPos = new ChunkPos(blockPos);
            Iterator iterator = ChunkPos.rangeClosed((ChunkPos)currentChunkPos, (int)8).toList().iterator();
            while (iterator.hasNext() && (shoalPos = ShoalSpawner.spawn(serverLevel, (chunkPos = (ChunkPos)iterator.next()).getMinBlockX(), chunkPos.getMinBlockZ())) == null) {
            }
            if (shoalPos == null) {
                FishOfThieves.LOGGER.debug("Shoal spawning attempt: {}", (Object)maxAttempt);
                return ShoalSpawner.attemptSpawnShoal(serverLevel, blockPos, maxAttempt - 1);
            }
            FishOfThieves.LOGGER.debug("Attempted to spawn shoal at: {}", (Object)shoalPos.below());
            return shoalPos.below();
        }
        return null;
    }

    @Nullable
    private static BlockPos spawnShoalAtSuitablePos(ServerLevel level, BlockPos pos) {
        BlockPos blockPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos);
        Holder biome = level.getBiome(blockPos);
        boolean isException = biome.is(FOTTags.Biomes.SHOAL_CANNOT_SPAWN);
        if (isException || !biome.is(FOTTags.Biomes.SPAWNS_SHOAL) || ShoalSpawner.findNearestExistingShoal(level, blockPos).isPresent()) {
            return null;
        }
        BlockState belowState = level.getBlockState(blockPos.below());
        if (belowState.is(Blocks.ICE)) {
            blockPos = blockPos.below();
        }
        if ((ShoalSpawner.isOpenWater(level, blockPos) || belowState.is(Blocks.ICE)) && ShoalChance.canSpawnAt(level, blockPos)) {
            level.setBlock(blockPos.below(), FOTBlocks.SHOAL.defaultBlockState(), 3);
            Shoal shoal = (Shoal)FOTEntities.SHOAL.create((Level)level);
            shoal.moveTo((double)blockPos.getX() + 0.5, (double)blockPos.getY() - 0.75, (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
            shoal.createNaturalSpawn(true);
            level.addFreshEntity((Entity)shoal);
            FishOfThieves.LOGGER.debug("Spawn shoal at region {}, {}, {}, {}", new Object[]{((ResourceKey)biome.unwrapKey().get()).location(), blockPos.getX(), blockPos.getY(), blockPos.getZ()});
            if (FishOfThieves.CONFIG.debug.spawnBeaconAtShoal && FOTPlatform.isDevelopment()) {
                ShoalSpawner.spawnBeacon(level, blockPos);
            }
            return blockPos;
        }
        return null;
    }

    private static Optional<BlockPos> findNearestExistingShoal(ServerLevel level, BlockPos pos) {
        Optional optional = level.getPoiManager().findClosest(holder -> holder.is(FOTTags.PoiTypes.SHOAL), blockPos -> level.getBlockState(blockPos.above(1)).is(Blocks.ICE) || blockPos.getY() == level.getHeight(Heightmap.Types.WORLD_SURFACE, blockPos.getX(), blockPos.getZ()) - 1, pos, FishOfThieves.CONFIG.shoal.spreadDistance, PoiManager.Occupancy.ANY);
        return optional.map(blockPos -> blockPos.above(1));
    }

    private static boolean isOpenWater(ServerLevel level, BlockPos pos) {
        boolean hasSourceWater = BlockPos.betweenClosedStream((BlockPos)pos.offset(-2, -1, -2), (BlockPos)pos.offset(2, -2, 2)).allMatch(blockPos -> {
            BlockState blockState = level.getBlockState(blockPos);
            FluidState fluidState = blockState.getFluidState();
            return fluidState.is(FluidTags.WATER) && fluidState.isSource() && blockState.getCollisionShape((BlockGetter)level, blockPos).isEmpty();
        });
        boolean hasOpenAir = BlockPos.betweenClosedStream((BlockPos)pos.offset(-2, 0, -2), (BlockPos)pos.offset(2, 0, 2)).allMatch(blockPos -> {
            BlockState blockState = level.getBlockState(blockPos);
            return level.canSeeSky(blockPos) && blockState.isAir() && !blockState.is(Blocks.LILY_PAD);
        });
        return hasSourceWater && hasOpenAir;
    }

    private static void spawnBeacon(ServerLevel level, BlockPos blockPos) {
        for (BlockPos blockPos1 : BlockPos.betweenClosed((BlockPos)blockPos.offset(-1, -5, -1), (BlockPos)blockPos.offset(1, -5, 1))) {
            level.setBlock(blockPos1, Blocks.IRON_BLOCK.defaultBlockState(), 3);
        }
        level.setBlock(blockPos.below(4), Blocks.BEACON.defaultBlockState(), 3);
    }
}

