/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.shoal;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.shoal.ShoalSpawnContext;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public enum ShoalChance {
    RIVER_OR_BEACH(context -> context.biome().is(BiomeTags.IS_RIVER) || context.biome().is(BiomeTags.IS_BEACH), FishOfThieves.CONFIG.shoal.weight.riverOrBeach),
    TROPICAL_ISLAND(context -> context.biome().is(FOTBiomes.TROPICAL_ISLAND), FishOfThieves.CONFIG.shoal.weight.tropicalIsland),
    COAST(context -> context.continentalness() == Continentalness.COAST, FishOfThieves.CONFIG.shoal.weight.coast),
    OCEAN(context -> context.biome().is(BiomeTags.IS_OCEAN), FishOfThieves.CONFIG.shoal.weight.ocean),
    DEEP_OCEAN(context -> context.biome().is(BiomeTags.IS_DEEP_OCEAN), FishOfThieves.CONFIG.shoal.weight.deepOcean),
    SWAMP(context -> context.biome().is(Biomes.SWAMP) || context.biome().is(Biomes.MANGROVE_SWAMP), FishOfThieves.CONFIG.shoal.weight.swamp);

    private static final ShoalChance[] VALUES;
    private final Predicate<ShoalSpawnContext> context;
    private final int poolWeight;

    private ShoalChance(Predicate<ShoalSpawnContext> context, int poolWeight) {
        this.context = context;
        this.poolWeight = poolWeight;
    }

    private boolean canSpawnAt(ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        Continentalness continentalness;
        Holder biome = level.getBiome(blockPos);
        ShoalSpawnContext context = new ShoalSpawnContext((Holder<Biome>)biome, continentalness = TerrainUtils.getContinentalness(level, blockPos));
        if (this.context.test(context)) {
            float weight = (float)this.poolWeight / 100.0f;
            float randomChance = randomSource.nextFloat();
            boolean canSpawn = weight <= randomChance;
            FishOfThieves.LOGGER.debug("Shoal {} at {}, weight/randomChance: {} <= {}, canSpawn: {}", new Object[]{this.name(), blockPos.toShortString(), Float.valueOf(weight), Float.valueOf(randomChance), canSpawn});
            return canSpawn;
        }
        return false;
    }

    public static boolean canSpawnAt(ServerLevel level, BlockPos blockPos) {
        return ((ShoalChance)((Object)Util.getRandom((Object[])VALUES, (RandomSource)level.getRandom()))).canSpawnAt(level, blockPos, level.getRandom());
    }

    static {
        VALUES = ShoalChance.values();
    }
}

