/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllOfCondition;
import com.stevekung.fishofthieves.entity.condition.AnyOfCondition;
import com.stevekung.fishofthieves.entity.condition.DayCondition;
import com.stevekung.fishofthieves.entity.condition.MatchBiomeCondition;
import com.stevekung.fishofthieves.entity.condition.MoonBrightnessCondition;
import com.stevekung.fishofthieves.entity.condition.NightCondition;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCondition;
import com.stevekung.fishofthieves.entity.condition.RainingCondition;
import com.stevekung.fishofthieves.entity.condition.RandomChanceCondition;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.WreckerVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class WreckerVariants {
    public static final ResourceKey<WreckerVariant> ROSE = WreckerVariants.createKey("rose");
    public static final ResourceKey<WreckerVariant> SUN = WreckerVariants.createKey("sun");
    public static final ResourceKey<WreckerVariant> BLACKCLOUD = WreckerVariants.createKey("blackcloud");
    public static final ResourceKey<WreckerVariant> SNOW = WreckerVariants.createKey("snow");
    public static final ResourceKey<WreckerVariant> MOON = WreckerVariants.createKey("moon");
    public static final ResourceKey<WreckerVariant> EMERALD = WreckerVariants.createKey("emerald");

    public static void bootstrap(BootstrapContext<WreckerVariant> context) {
        AbstractFishVariant.RegisterContext<WreckerVariant> registerContext = AbstractFishVariant.RegisterContext.create("wrecker", WreckerVariant::new);
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        registerContext.register(context, ROSE, "rose", 0, new SpawnCondition[0]);
        registerContext.register(context, SUN, "sun", 1, true, AllOfCondition.allOf(DayCondition.day(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, BLACKCLOUD, "blackcloud", 2, true, AllOfCondition.allOf(RainingCondition.raining().thundering(true), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, SNOW, "snow", 3, true, AnyOfCondition.anyOf(ProbabilityCondition.defaultRareProbablity(), MatchBiomeCondition.biomes((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.FROZEN_OCEAN), biomeLookup.getOrThrow(Biomes.DEEP_FROZEN_OCEAN)})).and(RandomChanceCondition.chance(10))).build());
        registerContext.register(context, MOON, "moon", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky(), MoonBrightnessCondition.moonBrightness(MinMaxBounds.Doubles.atMost((double)1.0))).build());
        registerContext.register(context, EMERALD, "emerald", 5, true, true);
    }

    public static void bootstrapSimple(BootstrapContext<WreckerVariant> context) {
        AbstractFishVariant.RegisterContext<WreckerVariant> registerContext = AbstractFishVariant.RegisterContext.create("wrecker", WreckerVariant::new);
        registerContext.register(context, ROSE, "rose", 0, new SpawnCondition[0]);
        registerContext.register(context, SUN, "sun", 1, true, new SpawnCondition[0]);
        registerContext.register(context, BLACKCLOUD, "blackcloud", 2, true, new SpawnCondition[0]);
        registerContext.register(context, SNOW, "snow", 3, true, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, MOON, "moon", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, EMERALD, "emerald", 5, true, true);
    }

    private static ResourceKey<WreckerVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.WRECKER_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

