/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllOfCondition;
import com.stevekung.fishofthieves.entity.condition.DayCondition;
import com.stevekung.fishofthieves.entity.condition.NightCondition;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCondition;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.SplashtailVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SplashtailVariants {
    public static final ResourceKey<SplashtailVariant> RUBY = SplashtailVariants.createKey("ruby");
    public static final ResourceKey<SplashtailVariant> SUNNY = SplashtailVariants.createKey("sunny");
    public static final ResourceKey<SplashtailVariant> INDIGO = SplashtailVariants.createKey("indigo");
    public static final ResourceKey<SplashtailVariant> UMBER = SplashtailVariants.createKey("umber");
    public static final ResourceKey<SplashtailVariant> SEAFOAM = SplashtailVariants.createKey("seafoam");
    public static final ResourceKey<SplashtailVariant> OBSIDIAN = SplashtailVariants.createKey("obsidian");

    public static void bootstrap(BootstrapContext<SplashtailVariant> context) {
        AbstractFishVariant.RegisterContext<SplashtailVariant> registerContext = AbstractFishVariant.RegisterContext.create("splashtail", SplashtailVariant::new);
        registerContext.register(context, RUBY, "ruby", 0, new SpawnCondition[0]);
        registerContext.register(context, SUNNY, "sunny", 1, AllOfCondition.allOf(DayCondition.day(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, INDIGO, "indigo", 2, new SpawnCondition[0]);
        registerContext.register(context, UMBER, "umber", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, SEAFOAM, "seafoam", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, OBSIDIAN, "obsidian", 5, true, true);
    }

    public static void bootstrapSimple(BootstrapContext<SplashtailVariant> context) {
        AbstractFishVariant.RegisterContext<SplashtailVariant> registerContext = AbstractFishVariant.RegisterContext.create("splashtail", SplashtailVariant::new);
        registerContext.register(context, RUBY, "ruby", 0, new SpawnCondition[0]);
        registerContext.register(context, SUNNY, "sunny", 1, new SpawnCondition[0]);
        registerContext.register(context, INDIGO, "indigo", 2, new SpawnCondition[0]);
        registerContext.register(context, UMBER, "umber", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, SEAFOAM, "seafoam", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, OBSIDIAN, "obsidian", 5, true, true);
    }

    private static ResourceKey<SplashtailVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.SPLASHTAIL_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

