/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllOfCondition;
import com.stevekung.fishofthieves.entity.condition.DayCondition;
import com.stevekung.fishofthieves.entity.condition.NightCondition;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCondition;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.PondieVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class PondieVariants {
    public static final ResourceKey<PondieVariant> CHARCOAL = PondieVariants.createKey("charcoal");
    public static final ResourceKey<PondieVariant> ORCHID = PondieVariants.createKey("orchid");
    public static final ResourceKey<PondieVariant> BRONZE = PondieVariants.createKey("bronze");
    public static final ResourceKey<PondieVariant> BRIGHT = PondieVariants.createKey("bright");
    public static final ResourceKey<PondieVariant> MOONSKY = PondieVariants.createKey("moonsky");
    public static final ResourceKey<PondieVariant> DEWDROP = PondieVariants.createKey("dewdrop");

    public static void bootstrap(BootstrapContext<PondieVariant> context) {
        AbstractFishVariant.RegisterContext<PondieVariant> registerContext = AbstractFishVariant.RegisterContext.create("pondie", PondieVariant::new);
        registerContext.register(context, CHARCOAL, "charcoal", 0, new SpawnCondition[0]);
        registerContext.register(context, ORCHID, "orchid", 1, new SpawnCondition[0]);
        registerContext.register(context, BRONZE, "bronze", 2, new SpawnCondition[0]);
        registerContext.register(context, BRIGHT, "bright", 3, AllOfCondition.allOf(ProbabilityCondition.defaultRareProbablity(), DayCondition.day(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, MOONSKY, "moonsky", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, DEWDROP, "dewdrop", 5, true, true);
    }

    public static void bootstrapSimple(BootstrapContext<PondieVariant> context) {
        AbstractFishVariant.RegisterContext<PondieVariant> registerContext = AbstractFishVariant.RegisterContext.create("pondie", PondieVariant::new);
        registerContext.register(context, CHARCOAL, "charcoal", 0, new SpawnCondition[0]);
        registerContext.register(context, ORCHID, "orchid", 1, new SpawnCondition[0]);
        registerContext.register(context, BRONZE, "bronze", 2, new SpawnCondition[0]);
        registerContext.register(context, BRIGHT, "bright", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, MOONSKY, "moonsky", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, DEWDROP, "dewdrop", 5, true, true);
    }

    private static ResourceKey<PondieVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.PONDIE_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

