/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllOfCondition;
import com.stevekung.fishofthieves.entity.condition.AnyOfCondition;
import com.stevekung.fishofthieves.entity.condition.HasBeehiveCondition;
import com.stevekung.fishofthieves.entity.condition.HeightCondition;
import com.stevekung.fishofthieves.entity.condition.LivingEntityHasEffectCondition;
import com.stevekung.fishofthieves.entity.condition.MatchBiomeCondition;
import com.stevekung.fishofthieves.entity.condition.MatchMinimumBlocksInRangeCondition;
import com.stevekung.fishofthieves.entity.condition.NightCondition;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCondition;
import com.stevekung.fishofthieves.entity.condition.RandomChanceCondition;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.IslehopperVariant;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class IslehopperVariants {
    public static final ResourceKey<IslehopperVariant> STONE = IslehopperVariants.createKey("stone");
    public static final ResourceKey<IslehopperVariant> MOSS = IslehopperVariants.createKey("moss");
    public static final ResourceKey<IslehopperVariant> HONEY = IslehopperVariants.createKey("honey");
    public static final ResourceKey<IslehopperVariant> RAVEN = IslehopperVariants.createKey("raven");
    public static final ResourceKey<IslehopperVariant> AMETHYST = IslehopperVariants.createKey("amethyst");
    public static final ResourceKey<IslehopperVariant> BRINY = IslehopperVariants.createKey("briny");

    public static void bootstrap(BootstrapContext<IslehopperVariant> context) {
        AbstractFishVariant.RegisterContext<IslehopperVariant> registerContext = AbstractFishVariant.RegisterContext.create("islehopper", IslehopperVariant::new);
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        registerContext.register(context, STONE, "stone", 0, new SpawnCondition[0]);
        registerContext.register(context, MOSS, "moss", 1, AnyOfCondition.anyOf(MatchBiomeCondition.biomes((HolderSet<Biome>)biomeLookup.getOrThrow(BiomeTags.IS_JUNGLE)), MatchBiomeCondition.biomes((HolderSet<Biome>)biomeLookup.getOrThrow(BiomeTags.HAS_CLOSER_WATER_FOG)), MatchBiomeCondition.biomes((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.LUSH_CAVES)})), MatchBiomeCondition.biomes((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(FOTBiomes.TROPICAL_ISLAND)}))).build());
        registerContext.register(context, HONEY, "honey", 2, HasBeehiveCondition.beehive(5, 12).build());
        registerContext.register(context, RAVEN, "raven", 3, List.of(AllOfCondition.allOf(ProbabilityCondition.defaultRareProbablity(), HeightCondition.height(MinMaxBounds.Ints.atMost((int)0))).build()), List.of(AnyOfCondition.anyOf(AllOfCondition.allOf(ProbabilityCondition.defaultRareProbablity(), HeightCondition.height(MinMaxBounds.Ints.atMost((int)0))), AllOfCondition.allOf(RandomChanceCondition.chance(3), LivingEntityHasEffectCondition.effect((HolderSet<MobEffect>)HolderSet.direct((Holder[])new Holder[]{MobEffects.BLINDNESS, MobEffects.DARKNESS})))).build()));
        registerContext.register(context, AMETHYST, "amethyst", 4, true, MatchMinimumBlocksInRangeCondition.minimumBlocksInRange(Optional.of(context.lookup(Registries.BLOCK).getOrThrow(FOTTags.Blocks.AMETHYST_ISLEHOPPER_SPAWNABLE_ON)), Optional.empty(), 4, 12).build());
        registerContext.register(context, BRINY, "briny", 5, true, true);
    }

    public static void bootstrapSimple(BootstrapContext<IslehopperVariant> context) {
        AbstractFishVariant.RegisterContext<IslehopperVariant> registerContext = AbstractFishVariant.RegisterContext.create("islehopper", IslehopperVariant::new);
        registerContext.register(context, STONE, "stone", 0, new SpawnCondition[0]);
        registerContext.register(context, MOSS, "moss", 1, new SpawnCondition[0]);
        registerContext.register(context, HONEY, "honey", 2, new SpawnCondition[0]);
        registerContext.register(context, RAVEN, "raven", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, AMETHYST, "amethyst", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, BRINY, "briny", 5, true, true);
    }

    private static ResourceKey<IslehopperVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.ISLEHOPPER_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

