/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllOfCondition;
import com.stevekung.fishofthieves.entity.condition.LivingEntityHasEffectCondition;
import com.stevekung.fishofthieves.entity.condition.MatchBiomeCondition;
import com.stevekung.fishofthieves.entity.condition.NightCondition;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCondition;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.BattlegillVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class BattlegillVariants {
    public static final ResourceKey<BattlegillVariant> JADE = BattlegillVariants.createKey("jade");
    public static final ResourceKey<BattlegillVariant> SKY = BattlegillVariants.createKey("sky");
    public static final ResourceKey<BattlegillVariant> RUM = BattlegillVariants.createKey("rum");
    public static final ResourceKey<BattlegillVariant> SAND = BattlegillVariants.createKey("sand");
    public static final ResourceKey<BattlegillVariant> BITTERSWEET = BattlegillVariants.createKey("bittersweet");
    public static final ResourceKey<BattlegillVariant> ZEST = BattlegillVariants.createKey("zest");

    public static void bootstrap(BootstrapContext<BattlegillVariant> context) {
        AbstractFishVariant.RegisterContext<BattlegillVariant> registerContext = AbstractFishVariant.RegisterContext.create("battlegill", BattlegillVariant::new);
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        registerContext.register(context, JADE, "jade", 0, new SpawnCondition[0]);
        registerContext.register(context, SKY, "sky", 1, SeeSkyCondition.seeSky().build());
        registerContext.register(context, RUM, "rum", 2, List.of(), List.of(LivingEntityHasEffectCondition.effect((HolderSet<MobEffect>)HolderSet.direct((Holder[])new Holder[]{MobEffects.CONFUSION})).build()));
        registerContext.register(context, SAND, "sand", 3, AllOfCondition.allOf(ProbabilityCondition.defaultRareProbablity(), MatchBiomeCondition.biomes((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.DESERT), biomeLookup.getOrThrow(Biomes.WARM_OCEAN), biomeLookup.getOrThrow(Biomes.LUKEWARM_OCEAN), biomeLookup.getOrThrow(Biomes.DEEP_LUKEWARM_OCEAN)}))).build());
        registerContext.register(context, BITTERSWEET, "bittersweet", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, ZEST, "zest", 5, true, true);
    }

    public static void bootstrapSimple(BootstrapContext<BattlegillVariant> context) {
        AbstractFishVariant.RegisterContext<BattlegillVariant> registerContext = AbstractFishVariant.RegisterContext.create("battlegill", BattlegillVariant::new);
        registerContext.register(context, JADE, "jade", 0, new SpawnCondition[0]);
        registerContext.register(context, SKY, "sky", 1, new SpawnCondition[0]);
        registerContext.register(context, RUM, "rum", 2, new SpawnCondition[0]);
        registerContext.register(context, SAND, "sand", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, BITTERSWEET, "bittersweet", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, ZEST, "zest", 5, true, true);
    }

    private static ResourceKey<BattlegillVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.BATTLEGILL_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

