/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllOfCondition;
import com.stevekung.fishofthieves.entity.condition.MoonBrightnessCondition;
import com.stevekung.fishofthieves.entity.condition.NightCondition;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCondition;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.AncientscaleVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class AncientscaleVariants {
    public static final ResourceKey<AncientscaleVariant> ALMOND = AncientscaleVariants.createKey("almond");
    public static final ResourceKey<AncientscaleVariant> SAPPHIRE = AncientscaleVariants.createKey("sapphire");
    public static final ResourceKey<AncientscaleVariant> SMOKE = AncientscaleVariants.createKey("smoke");
    public static final ResourceKey<AncientscaleVariant> BONE = AncientscaleVariants.createKey("bone");
    public static final ResourceKey<AncientscaleVariant> STARSHINE = AncientscaleVariants.createKey("starshine");
    public static final ResourceKey<AncientscaleVariant> BLOSSOM = AncientscaleVariants.createKey("blossom");

    public static void bootstrap(BootstrapContext<AncientscaleVariant> context) {
        AbstractFishVariant.RegisterContext<AncientscaleVariant> registerContext = AbstractFishVariant.RegisterContext.create("ancientscale", AncientscaleVariant::new);
        registerContext.register(context, ALMOND, "almond", 0, new SpawnCondition[0]);
        registerContext.register(context, SAPPHIRE, "sapphire", 1, new SpawnCondition[0]);
        registerContext.register(context, SMOKE, "smoke", 2, new SpawnCondition[0]);
        registerContext.register(context, BONE, "bone", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, STARSHINE, "starshine", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky(), MoonBrightnessCondition.moonBrightness(MinMaxBounds.Doubles.atMost((double)0.25))).build());
        registerContext.register(context, BLOSSOM, "blossom", 5, true, true);
    }

    public static void bootstrapSimple(BootstrapContext<AncientscaleVariant> context) {
        AbstractFishVariant.RegisterContext<AncientscaleVariant> registerContext = AbstractFishVariant.RegisterContext.create("ancientscale", AncientscaleVariant::new);
        registerContext.register(context, ALMOND, "almond", 0, new SpawnCondition[0]);
        registerContext.register(context, SAPPHIRE, "sapphire", 1, new SpawnCondition[0]);
        registerContext.register(context, SMOKE, "smoke", 2, new SpawnCondition[0]);
        registerContext.register(context, BONE, "bone", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, STARSHINE, "starshine", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
        registerContext.register(context, BLOSSOM, "blossom", 5, true, true);
    }

    private static ResourceKey<AncientscaleVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.ANCIENTSCALE_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

