/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.ai.sensing.FishAttackablesSensor;
import com.stevekung.fishofthieves.entity.ai.sensing.LowBrightnessSensor;
import com.stevekung.fishofthieves.entity.ai.sensing.MagmaBlockSensor;
import com.stevekung.fishofthieves.entity.ai.sensing.NearestFlockLeaderSensor;
import com.stevekung.fishofthieves.entity.ai.sensing.NearestSchoolingThievesFishSensor;
import com.stevekung.fishofthieves.entity.ai.sensing.NearestWreckerLocatedSensor;
import com.stevekung.fishofthieves.entity.ai.sensing.NonCreativePlayerSensor;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.sensing.TemptingSensor;

public class FOTSensorTypes {
    public static final SensorType<TemptingSensor> COMMON_THIEVES_FISH_TEMPTATIONS = FOTSensorTypes.register("common_thieves_fish_temptations", new SensorType(() -> new TemptingSensor((Predicate)AbstractThievesFishAi.getCommonTemptations())));
    public static final SensorType<TemptingSensor> LEECHES_THIEVES_FISH_TEMPTATIONS = FOTSensorTypes.register("leeches_thieves_fish_temptations", new SensorType(() -> new TemptingSensor((Predicate)AbstractThievesFishAi.getLeechesTemptations())));
    public static final SensorType<TemptingSensor> EARTHWORMS_THIEVES_FISH_TEMPTATIONS = FOTSensorTypes.register("earthworms_thieves_fish_temptations", new SensorType(() -> new TemptingSensor((Predicate)AbstractThievesFishAi.getEarthwormsTemptations())));
    public static final SensorType<TemptingSensor> GRUBS_THIEVES_FISH_TEMPTATIONS = FOTSensorTypes.register("grubs_thieves_fish_temptations", new SensorType(() -> new TemptingSensor((Predicate)AbstractThievesFishAi.getGrubsTemptations())));
    public static final SensorType<NearestWreckerLocatedSensor> NEAREST_WRECKER_LOCATED = FOTSensorTypes.register("nearest_wrecker_located", new SensorType(NearestWreckerLocatedSensor::new));
    public static final SensorType<FishAttackablesSensor> BATTLEGILL_ATTACKABLES = FOTSensorTypes.register("battlegill_attackables", new SensorType(() -> new FishAttackablesSensor(target -> target.getType().is(FOTTags.EntityTypes.BATTLEGILL_ATTACKABLE))));
    public static final SensorType<FishAttackablesSensor> DEVILFISH_ATTACKABLES = FOTSensorTypes.register("devilfish_attackables", new SensorType(() -> new FishAttackablesSensor(target -> target.getType().is(FOTTags.EntityTypes.DEVILFISH_ATTACKABLE))));
    public static final SensorType<FishAttackablesSensor> WRECKER_ATTACKABLES = FOTSensorTypes.register("wrecker_attackables", new SensorType(() -> new FishAttackablesSensor(target -> target.getType().is(FOTTags.EntityTypes.WRECKER_ATTACKABLE))));
    public static final SensorType<NonCreativePlayerSensor> NON_CREATIVE_NEAREST_PLAYERS = FOTSensorTypes.register("non_creative_nearest_players", new SensorType(NonCreativePlayerSensor::new));
    public static final SensorType<NearestSchoolingThievesFishSensor> NEAREST_SCHOOLING_THIEVES_FISH = FOTSensorTypes.register("nearest_schooling_thieves_fish", new SensorType(NearestSchoolingThievesFishSensor::new));
    public static final SensorType<MagmaBlockSensor> NEAREST_MAGMA_BLOCK = FOTSensorTypes.register("nearest_magma_block", new SensorType(MagmaBlockSensor::new));
    public static final SensorType<LowBrightnessSensor> LOW_BRIGHTNESS = FOTSensorTypes.register("low_brightness", new SensorType(LowBrightnessSensor::new));
    public static final SensorType<NearestFlockLeaderSensor> NEAREST_FLOCK_LEADER = FOTSensorTypes.register("nearest_flock_leader", new SensorType(NearestFlockLeaderSensor::new));

    public static void init() {
        FishOfThieves.LOGGER.info("Registering Sensor Type");
    }

    private static <U extends Sensor<?>> SensorType<U> register(String key, SensorType<U> sensorType) {
        return (SensorType)Registry.register((Registry)BuiltInRegistries.SENSOR_TYPE, (ResourceLocation)FishOfThieves.id(key), sensorType);
    }
}

