/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry;

import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.block.ShoalBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FOTPoiTypes {
    public static final ResourceKey<PoiType> NATURAL_SHOAL = FOTPoiTypes.createKey("natural_shoal");
    public static final ResourceKey<PoiType> TREASURED_SHOAL = FOTPoiTypes.createKey("treasured_shoal");

    public static void init() {
        FOTPoiTypes.register(NATURAL_SHOAL, Set.of((BlockState)FOTBlocks.SHOAL.defaultBlockState().setValue((Property)ShoalBlock.TREASURED, (Comparable)Boolean.valueOf(false))), 0, 1);
        FOTPoiTypes.register(TREASURED_SHOAL, Set.of((BlockState)FOTBlocks.SHOAL.defaultBlockState().setValue((Property)ShoalBlock.TREASURED, (Comparable)Boolean.valueOf(true))), 0, 1);
        FishOfThieves.LOGGER.info("Registering Poi Types");
    }

    private static void register(ResourceKey<PoiType> value, Set<BlockState> matchingStates, int maxTickets, int validRange) {
        Registry key = BuiltInRegistries.POINT_OF_INTEREST_TYPE;
        PoiType poiType = new PoiType(matchingStates, maxTickets, validRange);
        Registry.register((Registry)key, value, (Object)poiType);
        FOTPlatform.registerPoiBlockStates((Holder<PoiType>)key.getHolderOrThrow(value), matchingStates);
    }

    private static ResourceKey<PoiType> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (ResourceLocation)FishOfThieves.id(name));
    }
}

