/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.neoforge.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.ModifiableStructureInfo;
import net.neoforged.neoforge.common.world.StructureModifier;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="fishofthieves")
public class FOTStructureModifiers {
    private static final String THIEVES_FISH_SPAWNS_IN_STRUCTURE = "thieves_fish_spawns_in_structure";
    private static final ResourceLocation ADD_THIEVES_FISH_SPAWNS_IN_STRUCTURE_RL = FishOfThieves.id("thieves_fish_spawns_in_structure");
    private static final DeferredRegister<MapCodec<? extends StructureModifier>> STRUCTURE_MODIFIERS = DeferredRegister.create((Registry)NeoForgeRegistries.STRUCTURE_MODIFIER_SERIALIZERS, (String)"fishofthieves");
    private static final Codec<TagKey<Structure>> STRUCTURE_LIST_CODEC = TagKey.hashedCodec((ResourceKey)Registries.STRUCTURE);
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(NeoForgeRegistries.Keys.STRUCTURE_MODIFIERS, context -> {
        context.register(FOTStructureModifiers.key("ancientscales_spawn_in"), (Object)FOTStructureModifiers.addStructureSpawns((MobSpawnSettings.SpawnerData)FOTEntities.SpawnData.ANCIENTSCALE.unwrap().getFirst(), FOTTags.Structures.ANCIENTSCALES_SPAWN_IN));
        context.register(FOTStructureModifiers.key("wreckers_spawn_in"), (Object)FOTStructureModifiers.addStructureSpawns((MobSpawnSettings.SpawnerData)FOTEntities.SpawnData.WRECKER.unwrap().getFirst(), FOTTags.Structures.WRECKERS_SPAWN_IN));
        context.register(FOTStructureModifiers.key("battlegills_spawn_in"), (Object)FOTStructureModifiers.addStructureSpawns((MobSpawnSettings.SpawnerData)FOTEntities.SpawnData.BATTLEGILL.unwrap().getFirst(), FOTTags.Structures.BATTLEGILLS_SPAWN_IN));
    });

    public FOTStructureModifiers() {
        IEventBus modEventBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        STRUCTURE_MODIFIERS.register(modEventBus);
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        event.register(NeoForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, helper -> helper.register(ADD_THIEVES_FISH_SPAWNS_IN_STRUCTURE_RL, Modifier.makeCodec()));
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), output -> new StructureModifiers(output, event.getLookupProvider()));
    }

    private static StructureModifier addStructureSpawns(MobSpawnSettings.SpawnerData spawnerData, TagKey<Structure> structureTagKey) {
        return new Modifier(structureTagKey, spawnerData);
    }

    private static ResourceKey<StructureModifier> key(String key) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.STRUCTURE_MODIFIERS, (ResourceLocation)FishOfThieves.id(key));
    }

    public record Modifier(TagKey<Structure> structureTagKey, MobSpawnSettings.SpawnerData spawnerData) implements StructureModifier
    {
        private static final DeferredHolder<MapCodec<? extends StructureModifier>, MapCodec<? extends StructureModifier>> SERIALIZER = DeferredHolder.create((ResourceKey)NeoForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, (ResourceLocation)ADD_THIEVES_FISH_SPAWNS_IN_STRUCTURE_RL);

        public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
            if (phase == StructureModifier.Phase.ADD && structure.is(this.structureTagKey)) {
                builder.getStructureSettings().getOrAddSpawnOverrides(this.spawnerData.type.getCategory()).addSpawn(this.spawnerData);
            }
        }

        public MapCodec<? extends StructureModifier> codec() {
            return (MapCodec)SERIALIZER.get();
        }

        public static MapCodec<Modifier> makeCodec() {
            return RecordCodecBuilder.mapCodec(builder -> builder.group((App)STRUCTURE_LIST_CODEC.fieldOf("structure").forGetter(Modifier::structureTagKey), (App)MobSpawnSettings.SpawnerData.CODEC.fieldOf("spawnerData").forGetter(Modifier::spawnerData)).apply((Applicative)builder, Modifier::new));
        }
    }

    private static class StructureModifiers
    extends DatapackBuiltinEntriesProvider {
        public StructureModifiers(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries, BUILDER, Set.of("fishofthieves"));
        }

        public String getName() {
            return "Structure Modifier Registries: fishofthieves";
        }
    }
}

