/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.neoforge;

import com.stevekung.fishofthieves.entity.shoal.Shoal;
import com.stevekung.fishofthieves.neoforge.CompostableList;
import com.stevekung.fishofthieves.neoforge.FishOfThievesNeoForge;
import com.stevekung.fishofthieves.neoforge.mixin.accessor.CropBlockAccessor;
import com.stevekung.fishofthieves.network.ReceiveFishingHookBaitPacket;
import com.stevekung.fishofthieves.network.RequestServerShoalFishPacket;
import com.stevekung.fishofthieves.network.SyncClientShoalFishPacket;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;

public class FOTPlatformImpl {
    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static void addComposting(ItemLike item, float value) {
        CompostableList.COMPOSTABLES.put((Object)item, value);
    }

    public static void addFlammableBlock(Block block, int encouragement, int flammability) {
        FireBlock fireBlock = (FireBlock)Blocks.FIRE;
        fireBlock.setFlammable(block, encouragement, flammability);
    }

    public static <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BlockEntityType.BlockEntitySupplier<? extends T> factory, Block ... validBlocks) {
        return BlockEntityType.Builder.of(factory, (Block[])validBlocks).build(null);
    }

    public static <T extends Entity> EntityType<T> createEntityType(EntityType.EntityFactory<T> entityFactory, EntityDimensions dimensions) {
        return EntityType.Builder.of(entityFactory, (MobCategory)MobCategory.WATER_AMBIENT).sized(dimensions.width(), dimensions.height()).clientTrackingRange(4).build("");
    }

    public static <T extends Entity> EntityType<T> createEntityType(EntityType.EntityFactory<T> entityFactory, MobCategory mobCategory, EntityDimensions dimensions, int clientTrackingRange) {
        return EntityType.Builder.of(entityFactory, (MobCategory)mobCategory).sized(dimensions.width(), dimensions.height()).clientTrackingRange(clientTrackingRange).build("");
    }

    public static float getGrowthSpeedFromCropBlock(BlockState state, ServerLevel level, BlockPos pos) {
        return CropBlockAccessor.callGetGrowthSpeed(state, (BlockGetter)level, pos);
    }

    public static void registerSerializer(String name, EntityDataSerializer<?> serializer) {
        FishOfThievesNeoForge.ENTITY_DATA_SERIALIZERS.register(name, () -> serializer);
    }

    public static CreativeModeTab.Builder getCreativeTabBuilder() {
        return CreativeModeTab.builder();
    }

    public static <T extends GameRules.Value<T>> GameRules.Key<T> registerGameRule(String name, GameRules.Category category, GameRules.Type<T> type) {
        return GameRules.register((String)("fishofthieves:" + name), (GameRules.Category)category, type);
    }

    public static GameRules.Type<GameRules.BooleanValue> getGameRuleBoolean(boolean defaultValue) {
        return GameRules.BooleanValue.create((boolean)defaultValue);
    }

    public static void sendFishingHookBait(FishingHook fishingHook) {
        Level level = fishingHook.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer serverPlayer2 : serverLevel.getPlayers(serverPlayer -> serverPlayer.isAlive() && serverPlayer.distanceTo((Entity)fishingHook) < 1024.0f)) {
                serverPlayer2.connection.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new ReceiveFishingHookBaitPacket(fishingHook.getId(), fishingHook.fishofthieves$getBaitStack())));
            }
        }
    }

    public static void syncClientShoalFish(Shoal shoal, boolean forcedUpdate) {
        Level level = shoal.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer serverPlayer2 : serverLevel.getPlayers(serverPlayer -> serverPlayer.isAlive() && serverPlayer.distanceTo((Entity)shoal) < 1024.0f)) {
                serverPlayer2.connection.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new SyncClientShoalFishPacket(shoal.getId(), shoal.getShoalFish(), forcedUpdate)));
            }
        }
    }

    public static void requestServerShoalFish(Shoal shoal) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection != null) {
            connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new RequestServerShoalFishPacket(shoal.getId())));
        }
    }

    public static void registerPoiBlockStates(Holder<PoiType> poi, Set<BlockState> states) {
    }
}

