/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.mixin.trading;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.item.trade.RestockableData;
import com.stevekung.fishofthieves.item.trade.RestockableVillager;
import com.stevekung.fishofthieves.item.trade.TreasuredFishMapForEmeralds;
import com.stevekung.fishofthieves.item.trade.TreasuredFishMapRestock;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class MixinVillager
extends AbstractVillager
implements RestockableVillager {
    MixinVillager() {
        super(null, null);
    }

    @Inject(method={"restock()V", "catchUpDemand()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;getOffers()Lnet/minecraft/world/item/trading/MerchantOffers;")})
    private void fishofthieves$treasuredFishMapRestock(CallbackInfo info, @Share(value="treasuredMapOfferIndex") LocalIntRef treasuredMapOfferIndexRef) {
        Set data = this.fishofthieves$getRestockableDataSet();
        treasuredMapOfferIndexRef.set(-1);
        for (int index = 0; index < this.getOffers().size(); ++index) {
            MerchantOffer offer = (MerchantOffer)this.getOffers().get(index);
            int finalIndex = index;
            Optional<RestockableData> optional = data.stream().filter(restockableData -> restockableData.index() == finalIndex).findFirst();
            if (!optional.isPresent()) continue;
            FishOfThieves.LOGGER.debug("Restock merchant offer at index {} with data: {}", (Object)index, (Object)optional.get());
            TreasuredFishMapRestock treasuredFishOffer = (TreasuredFishMapRestock)offer;
            if (!offer.isOutOfStock()) continue;
            Pair<ItemStack, Integer> pair = TreasuredFishMapForEmeralds.getTreasuredFishMap((ServerLevel)this.level(), (Entity)this, "filled_map.fishofthieves_treasured_fish", optional.get().tier());
            if (pair != null) {
                treasuredFishOffer.fishofthieves$setResult((ItemStack)pair.getFirst());
                offer.getBaseCostA().setCount(((Integer)pair.getSecond()).intValue());
                FishOfThieves.LOGGER.debug("Villager {} has restocked at {}", (Object)this, (Object)this.blockPosition().toShortString());
                continue;
            }
            FishOfThieves.LOGGER.debug("Villager {} at {} cannot restock due to no suitable locations for shoal", (Object)this, (Object)this.blockPosition().toShortString());
            treasuredMapOfferIndexRef.set(index);
        }
    }

    @Inject(method={"restock()V", "catchUpDemand()V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/trading/MerchantOffer;resetUses()V")})
    private void fishofthieves$storeOfferIndexAndCancelResetUses(CallbackInfo info, @Share(value="offerIndex") LocalIntRef offerIndexRef, @Share(value="treasuredMapOfferIndex") LocalIntRef treasuredMapOfferIndexRef) {
        int offerIndex = offerIndexRef.get();
        offerIndexRef.set(offerIndex + 1);
        FishOfThieves.LOGGER.debug("offerIndex: {}, treasuredMapOfferIndex: {}", (Object)offerIndex, (Object)treasuredMapOfferIndexRef.get());
        if (offerIndex == treasuredMapOfferIndexRef.get()) {
            FishOfThieves.LOGGER.debug("Prevent reset uses at index: {}", (Object)offerIndex);
            info.cancel();
        }
    }
}

