/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.mixin.trading;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.DynamicOps;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.item.trade.RestockableData;
import com.stevekung.fishofthieves.item.trade.RestockableMerchantOffer;
import com.stevekung.fishofthieves.item.trade.RestockableVillager;
import com.stevekung.fishofthieves.registry.FOTMapDecorationTypes;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractVillager.class})
public abstract class MixinAbstractVillager
extends AgeableMob
implements RestockableVillager {
    @Shadow
    @Nullable
    MerchantOffers offers;
    @Unique
    private Set<RestockableData> restockableDataSet = new LinkedHashSet<RestockableData>();

    MixinAbstractVillager() {
        super(null, null);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;put(Ljava/lang/String;Lnet/minecraft/nbt/Tag;)Lnet/minecraft/nbt/Tag;", shift=At.Shift.AFTER)})
    private void fishofthieves$saveRestockableData(CompoundTag compound, CallbackInfo info, @Local MerchantOffers offers) {
        this.validateTreasuredFishMapIndex(offers);
        compound.put("RestockableData", (Tag)RestockableData.CODEC_LINKED_SET.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.restockableDataSet).getOrThrow());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void fishofthieves$readRestockableData(CompoundTag compound, CallbackInfo info) {
        if (compound.contains("RestockableData")) {
            RestockableData.CODEC_LINKED_SET.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("RestockableData")).resultOrPartial(Util.prefix((String)"Failed to load restock data: ", arg_0 -> ((Logger)FishOfThieves.LOGGER).warn(arg_0))).ifPresent(restockableDataList -> {
                this.restockableDataSet = restockableDataList;
            });
        }
        if (this.offers != null) {
            this.validateTreasuredFishMapIndex(this.offers);
        }
    }

    @Inject(method={"addOffersFromItemListings(Lnet/minecraft/world/item/trading/MerchantOffers;[Lnet/minecraft/world/entity/npc/VillagerTrades$ItemListing;I)V"}, at={@At(value="TAIL")})
    private void fishofthieves$addRestockableData(MerchantOffers givenMerchantOffers, VillagerTrades.ItemListing[] newTrades, int maxNumbers, CallbackInfo info) {
        for (int index = 0; index < givenMerchantOffers.size(); ++index) {
            MerchantOffer offer = (MerchantOffer)givenMerchantOffers.get(index);
            if (!(offer instanceof RestockableMerchantOffer)) continue;
            RestockableMerchantOffer restockableOffer = (RestockableMerchantOffer)offer;
            this.restockableDataSet.add(new RestockableData(index, restockableOffer.getTier()));
            FishOfThieves.LOGGER.debug("Restockable data added with index: {}", (Object)index);
        }
    }

    @Override
    public Set<RestockableData> fishofthieves$getRestockableDataSet() {
        return this.restockableDataSet;
    }

    @Unique
    private void validateTreasuredFishMapIndex(MerchantOffers offers) {
        for (int index = 0; index < offers.size(); ++index) {
            Function<RestockableData, Boolean> removeFunction;
            ItemStack result;
            block5: {
                block4: {
                    MerchantOffer offer = (MerchantOffer)offers.get(index);
                    result = offer.getResult();
                    int finalIndex = index;
                    removeFunction = restockableData -> restockableData.index() == finalIndex;
                    if (!result.is(Items.FILLED_MAP)) break block4;
                    if (result.has(DataComponents.MAP_DECORATIONS)) break block5;
                }
                this.restockableDataSet.removeIf(removeFunction::apply);
                continue;
            }
            if (!result.is(Items.FILLED_MAP) || !result.has(DataComponents.MAP_DECORATIONS)) continue;
            MapDecorations mapDecorations = (MapDecorations)result.get(DataComponents.MAP_DECORATIONS);
            for (MapDecorations.Entry entry : mapDecorations.decorations().values()) {
                if (entry.type().is(FOTMapDecorationTypes.TREASURED_FISH)) continue;
                this.restockableDataSet.removeIf(removeFunction::apply);
            }
        }
    }
}

