/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.mixin.entity;

import com.llamalad7.mixinextras.sugar.Local;
import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.entity.FishingHookBait;
import com.stevekung.fishofthieves.entity.shoal.Shoal;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.storage.BaitPreserveSavedData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHook.class})
public abstract class MixinFishingHook
extends Projectile
implements FishingHookBait {
    @Shadow
    int timeUntilLured;
    @Unique
    private ItemStack baitStack = ItemStack.EMPTY;
    @Unique
    private boolean isCreative;
    @Unique
    private boolean saved;

    @Shadow
    abstract Player getPlayerOwner();

    MixinFishingHook() {
        super(null, null);
    }

    public boolean save(CompoundTag compound) {
        Level level;
        if (!this.isCreative && !this.saved && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BaitPreserveSavedData baitPreserveSavedData = serverLevel.getBaitPreserve();
            baitPreserveSavedData.getBaitStorage().putIfAbsent(this.position(), this.baitStack);
            baitPreserveSavedData.setDirty();
            this.saved = true;
        }
        return super.save(compound);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;discard()V")})
    private void fishofthieves$dropBaitOnDiscardTick(CallbackInfo info) {
        this.dropBait();
    }

    @Inject(method={"shouldStopFishing(Lnet/minecraft/world/entity/player/Player;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;discard()V")})
    private void fishofthieves$dropBaitOnDiscardRemoved(Player player, CallbackInfoReturnable<Boolean> info) {
        this.dropBait();
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void fishofthieves$sendPacketOnFirstTick(CallbackInfo info) {
        if (this.level() instanceof ServerLevel && this.tickCount == 1) {
            FOTPlatform.sendFishingHookBait((FishingHook)FishingHook.class.cast(this));
        }
    }

    @Inject(method={"retrieve(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancements/critereon/FishingRodHookedTrigger;trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/projectile/FishingHook;Ljava/util/Collection;)V", shift=At.Shift.AFTER, ordinal=1)})
    private void fishofthieves$onRetrieve(ItemStack stack, CallbackInfoReturnable<Integer> info) {
        this.shrinkBait(false);
    }

    @Inject(method={"catchingFish(Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/syncher/SynchedEntityData;set(Lnet/minecraft/network/syncher/EntityDataAccessor;Ljava/lang/Object;)V", ordinal=0)})
    private void fishofthieves$shrinkBait(BlockPos pos, CallbackInfo info) {
        this.shrinkBait(true);
    }

    @Inject(method={"catchingFish(Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/projectile/FishingHook;timeUntilLured:I", opcode=181, ordinal=1, shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I", ordinal=1))})
    private void fishofthieves$increaseLureByBait(BlockPos pos, CallbackInfo info) {
        if (this.baitStack.is(FOTTags.Items.WORMS)) {
            this.timeUntilLured = Mth.floor((double)((double)this.timeUntilLured * 0.9));
        }
    }

    @Inject(method={"retrieve(Lnet/minecraft/world/item/ItemStack;)I"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/advancements/critereon/FishingRodHookedTrigger;trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/projectile/FishingHook;Ljava/util/Collection;)V", shift=At.Shift.AFTER, ordinal=1)})
    private void fishofthieves$fishUpShoal(ItemStack itemStack, CallbackInfoReturnable<Integer> info, @Local Player player) {
        Shoal shoal;
        boolean intersects;
        List shoals = this.level().getEntitiesOfClass(Shoal.class, this.getBoundingBox().inflate(1.0), Entity::isAlive);
        if (!shoals.isEmpty() && (intersects = (shoal = (Shoal)((Object)shoals.getFirst())).getBoundingBox().intersects(this.getBoundingBox().inflate(1.0)))) {
            LivingEntity randomFish = shoal.getRandomFishInShoal();
            if (randomFish == null) {
                return;
            }
            shoal.addParticipatePlayer(player.getUUID());
            double dx = player.getX() - this.getX();
            double dy = player.getY() - this.getY();
            double dz = player.getZ() - this.getZ();
            double power = 0.15;
            double gravity = 0.12;
            randomFish.moveTo(this.blockPosition(), -player.getYRot(), -player.getXRot());
            randomFish.setDeltaMovement(dx * power, dy * power + Math.sqrt(Math.sqrt(dx * dx + dy * dy + dz * dz)) * gravity, dz * power);
            randomFish.setAirSupply(500);
            this.level().addFreshEntity((Entity)randomFish);
            player.level().addFreshEntity((Entity)new ExperienceOrb(player.level(), player.getX() + 0.5, player.getY() + 0.5, player.getZ() + 0.5, this.random.nextInt(8) + 2));
            this.discard();
            info.setReturnValue((Object)4);
        }
    }

    @Override
    public void fishofthieves$setBaitStack(ItemStack itemStack) {
        this.baitStack = itemStack;
    }

    @Override
    public ItemStack fishofthieves$getBaitStack() {
        return this.baitStack;
    }

    @Override
    public void fishofthieves$setIsCreative() {
        this.isCreative = true;
    }

    @Unique
    private void shrinkBait(boolean sendPacket) {
        Player player = this.getPlayerOwner();
        if (player != null && !this.baitStack.isEmpty() && !player.getAbilities().instabuild) {
            this.baitStack.shrink(1);
            player.awardStat(Stats.ITEM_USED.get((Object)this.baitStack.getItem()));
            if (sendPacket) {
                FOTPlatform.sendFishingHookBait((FishingHook)FishingHook.class.cast(this));
            }
        }
    }

    @Unique
    private void dropBait() {
        Level level;
        if (!this.isCreative && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = Vec3.atLowerCornerWithOffset((Vec3i)this.blockPosition(), (double)0.5, (double)0.25, (double)0.5).offsetRandom(this.random, 0.3f);
            ItemEntity itemEntity = new ItemEntity(this.level(), vec3.x(), vec3.y(), vec3.z(), this.baitStack);
            itemEntity.setDefaultPickUpDelay();
            this.level().addFreshEntity((Entity)itemEntity);
            BaitPreserveSavedData baitPreserveSavedData = serverLevel.getBaitPreserve();
            baitPreserveSavedData.getBaitStorage().remove(this.position());
            baitPreserveSavedData.setDirty();
        }
    }
}

