/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.registry.FOTEntitySubPredicates;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record TreasuredFishPredicate(boolean treasured) implements EntitySubPredicate
{
    public static final MapCodec<TreasuredFishPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("treasured").forGetter(TreasuredFishPredicate::treasured)).apply((Applicative)instance, TreasuredFishPredicate::new));

    public MapCodec<TreasuredFishPredicate> codec() {
        return FOTEntitySubPredicates.TREASURED;
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof ThievesFish)) {
            return false;
        }
        ThievesFish thievesFish = (ThievesFish)entity;
        return this.treasured == thievesFish.isTreasured();
    }
}

