/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.function;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.shoal.Shoal;
import com.stevekung.fishofthieves.registry.FOTLootItemFunctions;
import com.stevekung.fishofthieves.registry.FOTMapDecorationTypes;
import com.stevekung.fishofthieves.registry.FOTPoiTypes;
import com.stevekung.fishofthieves.shoal.ShoalSpawner;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class TreasuredFishMapFunction
extends LootItemConditionalFunction {
    public static final MapCodec<TreasuredFishMapFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> TreasuredFishMapFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.BYTE.optionalFieldOf("zoom", (Object)2).forGetter(function -> function.zoom), (App)Codec.INT.fieldOf("mininum_search_radius").forGetter(function -> function.minimumSearchRadius), (App)Codec.INT.fieldOf("maximum_search_radius").forGetter(function -> function.maximumSearchRadius), (App)Codec.INT.fieldOf("max_attempt").forGetter(function -> function.maxAttempt), (App)Codec.FLOAT.fieldOf("high_tier_chance").forGetter(function -> Float.valueOf(function.highTierChance)))).apply((Applicative)instance, TreasuredFishMapFunction::new));
    private final byte zoom;
    private final int minimumSearchRadius;
    private final int maximumSearchRadius;
    private final int maxAttempt;
    private final float highTierChance;

    TreasuredFishMapFunction(List<LootItemCondition> conditions, byte zoom, int minimumSearchRadius, int maximumSearchRadius, int maxAttempt, float highTierChance) {
        super(conditions);
        this.zoom = zoom;
        this.minimumSearchRadius = minimumSearchRadius;
        this.maximumSearchRadius = maximumSearchRadius;
        this.maxAttempt = maxAttempt;
        this.highTierChance = highTierChance;
    }

    public LootItemFunctionType<TreasuredFishMapFunction> getType() {
        return FOTLootItemFunctions.TREASURED_FISH_MAP;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.ORIGIN);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        if (stack.is(Items.MAP)) {
            Vec3 vec3 = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
            if (vec3 == null) {
                return stack;
            }
            ServerLevel serverLevel = context.getLevel();
            Optional<BlockPos> farthest = ShoalSpawner.findFarthest(holder -> holder.is(FOTPoiTypes.NATURAL_SHOAL), BlockPos.containing((Position)vec3), this.minimumSearchRadius, this.maximumSearchRadius, serverLevel.getPoiManager());
            if (farthest.isPresent()) {
                BlockPos blockPos = farthest.get();
                FishOfThieves.LOGGER.debug("Found farthest shoal at: {}", (Object)blockPos);
                return TreasuredFishMapFunction.createTreasuredFishMap(serverLevel, blockPos, context, this.zoom, this.highTierChance);
            }
            BlockPos attemptPos = ShoalSpawner.attemptSpawnShoal(serverLevel, BlockPos.containing((Position)vec3), this.maxAttempt);
            if (attemptPos != null) {
                FishOfThieves.LOGGER.debug("Shoal spawn from map at: {}", (Object)attemptPos);
                return TreasuredFishMapFunction.createTreasuredFishMap(serverLevel, attemptPos, context, this.zoom, this.highTierChance);
            }
            Optional nearest = serverLevel.getPoiManager().findClosest(holder -> holder.is(FOTPoiTypes.NATURAL_SHOAL), BlockPos.containing((Position)vec3), this.maximumSearchRadius, PoiManager.Occupancy.ANY);
            if (nearest.isPresent()) {
                BlockPos blockPos = (BlockPos)nearest.get();
                FishOfThieves.LOGGER.debug("Found nearest shoal at: {}", (Object)blockPos);
                return TreasuredFishMapFunction.createTreasuredFishMap(serverLevel, blockPos, context, this.zoom, this.highTierChance);
            }
        }
        return stack;
    }

    private static ItemStack createTreasuredFishMap(ServerLevel serverLevel, BlockPos blockPos, LootContext context, byte zoom, float highTierChance) {
        ItemStack itemStack = MapItem.create((Level)serverLevel, (int)blockPos.getX(), (int)blockPos.getZ(), (byte)zoom, (boolean)true, (boolean)true);
        MapItem.renderBiomePreviewMap((ServerLevel)serverLevel, (ItemStack)itemStack);
        MapItemSavedData.addTargetDecoration((ItemStack)itemStack, (BlockPos)blockPos, (String)"+", FOTMapDecorationTypes.TREASURED_FISH);
        Shoal.setTreasuredShoal((Level)serverLevel, blockPos, context.getRandom().nextFloat() < highTierChance ? 1 : 2);
        return itemStack;
    }

    public static Builder makeTreasuredFishMap() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private byte zoom = (byte)2;
        private int minimumSearchRadius;
        private int maximumSearchRadius;
        private int maxAttempt;
        private float highTierChance;

        protected Builder getThis() {
            return this;
        }

        public Builder setZoom(byte zoom) {
            this.zoom = zoom;
            return this;
        }

        public Builder setMinimumSearchRadius(int minimumSearchRadius) {
            this.minimumSearchRadius = minimumSearchRadius;
            return this;
        }

        public Builder setMaximumSearchRadius(int maximumSearchRadius) {
            this.maximumSearchRadius = maximumSearchRadius;
            return this;
        }

        public Builder setMaxAttempt(int maxAttempt) {
            this.maxAttempt = maxAttempt;
            return this;
        }

        public Builder setHighTierChance(float highTierChance) {
            this.highTierChance = highTierChance;
            return this;
        }

        public LootItemFunction build() {
            return new TreasuredFishMapFunction(this.getConditions(), this.zoom, this.minimumSearchRadius, this.maximumSearchRadius, this.maxAttempt, this.highTierChance);
        }
    }
}

