/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.item.FOTItem;
import com.stevekung.fishofthieves.registry.FOTLootPoolEntries;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class FOTTagEntry
extends LootPoolSingletonContainer {
    public static final MapCodec<FOTTagEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("name").forGetter(tagEntry -> tagEntry.tag), (App)Codec.BOOL.fieldOf("expand").forGetter(tagEntry -> tagEntry.expand)).and(FOTTagEntry.singletonFields((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, FOTTagEntry::new));
    private final TagKey<Item> tag;
    private final boolean expand;

    FOTTagEntry(TagKey<Item> tagKey, boolean expand, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.tag = tagKey;
        this.expand = expand;
    }

    public LootPoolEntryType getType() {
        return FOTLootPoolEntries.TAG;
    }

    public void createItemStack(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
        BuiltInRegistries.ITEM.getTagOrEmpty(this.tag).forEach(holder -> this.createItemStackWithData(stackConsumer, lootContext, (Holder<Item>)holder));
    }

    private void createItemStackWithData(Consumer<ItemStack> stackConsumer, LootContext lootContext, Holder<Item> itemHolder) {
        ItemStack itemStack = new ItemStack(itemHolder);
        Vec3 vec3 = (Vec3)lootContext.getParamOrNull(LootContextParams.ORIGIN);
        Entity entity = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        stackConsumer.accept(FOTItem.generateRandomFishVariantLootItem(itemStack, entity, lootContext.getLevel(), vec3, lootContext.getRandom()));
    }

    private boolean expandTag(LootContext context, Consumer<LootPoolEntry> generatorConsumer) {
        if (!this.canRun(context)) {
            return false;
        }
        for (final Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
            generatorConsumer.accept((LootPoolEntry)new LootPoolSingletonContainer.EntryBase(){

                public void createItemStack(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
                    FOTTagEntry.this.createItemStackWithData(stackConsumer, lootContext, (Holder<Item>)holder);
                }
            });
        }
        return true;
    }

    public boolean expand(LootContext lootContext, Consumer<LootPoolEntry> consumer) {
        return this.expand ? this.expandTag(lootContext, consumer) : super.expand(lootContext, consumer);
    }

    public static LootPoolSingletonContainer.Builder<?> expandTag(TagKey<Item> tag) {
        return FOTTagEntry.simpleBuilder((weight, quality, conditions, functions) -> new FOTTagEntry(tag, true, weight, quality, conditions, functions));
    }
}

