/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTLootItemConditions;
import java.util.Set;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record BaitAttachedCondition(ItemPredicate itemPredicate, EntityPredicate entityPredicate) implements LootItemCondition
{
    public static final MapCodec<BaitAttachedCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemPredicate.CODEC.fieldOf("item").forGetter(BaitAttachedCondition::itemPredicate), (App)EntityPredicate.CODEC.fieldOf("entity").forGetter(BaitAttachedCondition::entityPredicate)).apply((Applicative)instance, BaitAttachedCondition::new));

    public LootItemConditionType getType() {
        return FOTLootItemConditions.BAIT_ATTACHED_HOOK;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.THIS_ENTITY);
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        return entity != null && this.entityPredicate.matches(context.getLevel(), null, entity) && this.checkBaitFromHook(entity);
    }

    private boolean checkBaitFromHook(Entity entity) {
        if (entity instanceof FishingHook) {
            FishingHook fishingHook = (FishingHook)entity;
            ItemStack baitStack = fishingHook.fishofthieves$getBaitStack();
            return !baitStack.isEmpty() && this.itemPredicate.test(baitStack);
        }
        return false;
    }

    public static LootItemCondition.Builder baitMatches(ItemPredicate.Builder itemPredicateBuilder, EntityPredicate.Builder entityPredicateBuilder) {
        return () -> new BaitAttachedCondition(itemPredicateBuilder.build(), entityPredicateBuilder.build());
    }
}

