/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ReturnedOnConsumeItem
extends Item {
    private final Supplier<Item> returnedItem;
    private final float chance;

    public ReturnedOnConsumeItem(Item.Properties properties, Supplier<Item> returnedItem, float chance) {
        super(properties);
        this.returnedItem = returnedItem;
        this.chance = chance;
    }

    public ReturnedOnConsumeItem(Item.Properties properties, Supplier<Item> returnedItem) {
        this(properties, returnedItem, 1.0f);
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        super.finishUsingItem(itemStack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, itemStack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!level.isClientSide()) {
            boolean hasChance;
            boolean bl = hasChance = level.getRandom().nextFloat() <= this.chance;
            if (hasChance) {
                if (itemStack.isEmpty()) {
                    return new ItemStack((ItemLike)this.returnedItem.get());
                }
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (!player.getAbilities().instabuild) {
                        ItemStack itemStack1 = new ItemStack((ItemLike)this.returnedItem.get());
                        if (!player.getInventory().add(itemStack1)) {
                            player.drop(itemStack1, false);
                        }
                    }
                }
                return itemStack;
            }
        }
        return itemStack;
    }
}

