/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;

public class FOTSpawnEggItem
extends SpawnEggItem {
    private final ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey;

    public FOTSpawnEggItem(EntityType<? extends Mob> defaultType, int backgroundColor, int highlightColor, ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey, Item.Properties properties) {
        super(defaultType, backgroundColor, highlightColor, properties);
        this.resourceKey = resourceKey;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (context.registries() != null) {
            CompoundTag entityTag = ((CustomData)itemStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
            boolean trophy = entityTag.getBoolean("Trophy");
            boolean treasured = false;
            for (Holder.Reference entry : context.registries().lookupOrThrow(this.resourceKey).listElements().toList()) {
                if (!((AbstractFishVariant)entry.value()).treasured().isPresent() || !entityTag.getString("variant").equals(entry.key().location().toString())) continue;
                tooltipComponents.add((Component)Component.translatable((String)(this.getType(itemStack).getDescriptionId() + "." + entry.key().location().getPath())).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}));
                treasured = true;
            }
            if (entityTag.contains("Trophy") && !treasured) {
                tooltipComponents.add((Component)Component.translatable((String)(trophy ? "entity.fishofthieves.trophy" : "entity.fishofthieves.non_trophy")).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
        }
    }

    public static void addSpawnEgg(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output, Item item) {
        if (FishOfThieves.CONFIG.general.displayTrophySpawnEggInCreativeTab) {
            output.accept(FOTSpawnEggItem.create(item, false));
            output.accept(FOTSpawnEggItem.create(item, true));
        } else {
            output.accept((ItemLike)item);
        }
        FOTSpawnEggItem spawnEgg = (FOTSpawnEggItem)item;
        for (Holder.Reference entry : itemDisplayParameters.holders().lookupOrThrow(spawnEgg.resourceKey).listElements().filter(holder -> ((AbstractFishVariant)holder.value()).treasured().isPresent()).toList()) {
            output.accept(FOTSpawnEggItem.createTreasured(item, entry.key().location().toString()));
        }
    }

    private static ItemStack create(Item item, boolean trophy) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CustomData.update((DataComponentType)DataComponents.ENTITY_DATA, (ItemStack)itemStack, compoundTag -> {
            compoundTag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)((SpawnEggItem)item).getType(itemStack)).toString());
            compoundTag.putBoolean("Trophy", trophy);
        });
        return itemStack;
    }

    private static ItemStack createTreasured(Item item, String variant) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CustomData.update((DataComponentType)DataComponents.ENTITY_DATA, (ItemStack)itemStack, compoundTag -> {
            compoundTag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)((SpawnEggItem)item).getType(itemStack)).toString());
            compoundTag.putBoolean("Trophy", true);
            compoundTag.putString("variant", variant);
        });
        return itemStack;
    }
}

