/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.item.FOTItem;
import com.stevekung.fishofthieves.item.ResourceKeyHolder;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;

public class FOTMobBucketItem
extends MobBucketItem
implements ResourceKeyHolder {
    private final EntityType<?> entityType;
    private final ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey;

    public FOTMobBucketItem(EntityType<?> entityType, Fluid fluid, SoundEvent soundEvent, ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey, Item.Properties properties) {
        super(entityType, fluid, soundEvent, properties);
        this.entityType = entityType;
        this.resourceKey = resourceKey;
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int slotId, boolean isSelected) {
        String registryKeyTag = this.resourceKey.location().getPath();
        if (itemStack.has(DataComponents.CUSTOM_MODEL_DATA)) {
            int customModelData = ((CustomModelData)itemStack.get(DataComponents.CUSTOM_MODEL_DATA)).value();
            if (FishOfThieves.CONFIG.general.enableFishItemDropWithVariant || customModelData == 0) {
                CustomData bucketEntityData = (CustomData)itemStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
                CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)itemStack, compoundTag -> {
                    compoundTag.putString(registryKeyTag, bucketEntityData.copyTag().getString("variant"));
                    compoundTag.remove("variant");
                });
                itemStack.remove(DataComponents.CUSTOM_MODEL_DATA);
            }
        } else if (!itemStack.has(DataComponents.BUCKET_ENTITY_DATA)) {
            String variant = ((Holder.Reference)level.registryAccess().registryOrThrow(this.resourceKey).holders().sorted(AbstractFishVariant.COMPARATOR).toList().getFirst()).key().location().toString();
            itemStack.set(DataComponents.BUCKET_ENTITY_DATA, (Object)FOTItem.createCustomData(registryKeyTag, variant));
        } else if (itemStack.has(DataComponents.CUSTOM_DATA)) {
            CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)itemStack, compoundTag -> compoundTag.merge(((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag()));
            itemStack.remove(DataComponents.CUSTOM_DATA);
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.entityType.is(FOTTags.EntityTypes.THIEVES_FISH_ENTITY_TYPE)) {
            CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            if (context.registries() != null && !customData.isEmpty()) {
                CompoundTag compoundTag = customData.copyTag();
                for (Holder.Reference reference : context.registries().lookupOrThrow(this.resourceKey).listElements().sorted(AbstractFishVariant.COMPARATOR).toList()) {
                    String key = reference.key().registry().getPath();
                    ResourceLocation variant = reference.key().location();
                    if (!compoundTag.getString(key).equals(variant.toString())) continue;
                    boolean treasured = ((AbstractFishVariant)reference.value()).treasured().isPresent();
                    MutableComponent type = this.createTooltip(variant.getPath(), treasured);
                    if (!treasured && compoundTag.getBoolean("Trophy")) {
                        type.append(", ").append((Component)Component.translatable((String)"entity.fishofthieves.trophy"));
                    }
                    tooltipComponents.add((Component)type);
                }
            }
        }
    }

    @Override
    public ResourceKey<? extends Registry<? extends AbstractFishVariant>> getResourceKey() {
        return this.resourceKey;
    }

    public static void addFishVariantsBucket(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output, Item item) {
        List<Holder<? extends AbstractFishVariant>> list = itemDisplayParameters.holders().lookupOrThrow(((FOTMobBucketItem)item).resourceKey).listElements().sorted(AbstractFishVariant.COMPARATOR).toList();
        for (int i = 0; i < list.size() && (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab || i <= 0); ++i) {
            Holder.Reference entry = (Holder.Reference)list.get(i);
            String key = entry.key().registry().getPath();
            ResourceLocation variant = entry.key().location();
            if (FishOfThieves.CONFIG.general.displayTrophyBucketInCreativeTab && ((AbstractFishVariant)entry.value()).treasured().isEmpty()) {
                if (((AbstractFishVariant)entry.value()).treasured().isEmpty()) {
                    output.accept(FOTMobBucketItem.create(item, key, variant.toString(), false));
                }
                output.accept(FOTMobBucketItem.create(item, key, variant.toString(), true));
                continue;
            }
            output.accept(FOTMobBucketItem.create(item, key, variant.toString(), null));
        }
    }

    private MutableComponent createTooltip(String variant, boolean treasured) {
        return Component.translatable((String)"entity.fishofthieves.%s.%s".formatted(BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType).getPath(), ResourceLocation.tryParse((String)variant).getPath())).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, treasured ? ChatFormatting.GOLD : ChatFormatting.GRAY});
    }

    public static ItemStack create(Item item, String registryPath, String variant, Boolean trophy) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)itemStack, compoundTag -> compoundTag.putString(registryPath, variant));
        if (!FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab) {
            CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)itemStack, compoundTag -> compoundTag.putBoolean("creative", true));
        }
        if (trophy != null) {
            CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)itemStack, compoundTag -> compoundTag.putBoolean("Trophy", trophy.booleanValue()));
        }
        return itemStack;
    }

    public static ItemStack createRandomBucket(Item item) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)itemStack, compoundTag -> compoundTag.putBoolean("creative", true));
        return itemStack;
    }
}

