/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.item.ResourceKeyHolder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FOTItem
extends Item
implements ResourceKeyHolder {
    private final EntityType<?> entityType;
    private final ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey;

    public FOTItem(Item.Properties properties, EntityType<?> entityType, ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey) {
        super(properties);
        this.entityType = entityType;
        this.resourceKey = resourceKey;
    }

    public static void addFishVariants(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output, Item item) {
        if (item instanceof ResourceKeyHolder) {
            ResourceKeyHolder keyHolder = (ResourceKeyHolder)item;
            List<Holder<? extends AbstractFishVariant>> list = itemDisplayParameters.holders().lookupOrThrow(keyHolder.getResourceKey()).listElements().sorted(AbstractFishVariant.COMPARATOR).toList();
            for (int i = 0; i < list.size() && (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab || i <= 0); ++i) {
                Holder.Reference entry = (Holder.Reference)list.get(i);
                String key = entry.key().registry().getPath();
                ResourceLocation variant = entry.key().location();
                output.accept(FOTItem.create(item, key, variant.toString()));
            }
        }
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int slotId, boolean isSelected) {
        String registryKeyTag = this.resourceKey.location().getPath();
        if (itemStack.has(DataComponents.CUSTOM_MODEL_DATA)) {
            int customModelData = ((CustomModelData)itemStack.get(DataComponents.CUSTOM_MODEL_DATA)).value();
            if (FishOfThieves.CONFIG.general.enableFishItemDropWithVariant || customModelData == 0) {
                String variant = level.registryAccess().registryOrThrow(this.resourceKey).holders().sorted(AbstractFishVariant.COMPARATOR).filter(holder -> ((AbstractFishVariant)holder.value()).order() == customModelData).findFirst().get().key().location().toString();
                itemStack.set(DataComponents.CUSTOM_DATA, (Object)FOTItem.createCustomData(registryKeyTag, variant));
                itemStack.remove(DataComponents.CUSTOM_MODEL_DATA);
            }
        } else if (!itemStack.has(DataComponents.CUSTOM_DATA)) {
            String variant = ((Holder.Reference)level.registryAccess().registryOrThrow(this.resourceKey).holders().sorted(AbstractFishVariant.COMPARATOR).toList().getFirst()).key().location().toString();
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)FOTItem.createCustomData(registryKeyTag, variant));
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (context.registries() != null) {
            for (Holder.Reference reference : context.registries().lookupOrThrow(this.resourceKey).listElements().sorted(AbstractFishVariant.COMPARATOR).toList()) {
                String key = reference.key().registry().getPath();
                ResourceLocation variant = reference.key().location();
                if (!customData.copyTag().getString(key).equals(variant.toString())) continue;
                tooltipComponents.add((Component)Component.translatable((String)(this.entityType.getDescriptionId() + "." + variant.getPath())).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ((AbstractFishVariant)reference.value()).treasured().isPresent() ? ChatFormatting.GOLD : ChatFormatting.GRAY}));
            }
        }
    }

    @Override
    public ResourceKey<? extends Registry<? extends AbstractFishVariant>> getResourceKey() {
        return this.resourceKey;
    }

    public static ItemStack generateRandomFishVariantLootItem(ItemStack itemStack, @Nullable Entity entity, ServerLevel level, @Nullable Vec3 vec3, RandomSource randomSource) {
        Item item;
        if (FishOfThieves.CONFIG.general.enableFishItemDropWithVariant && (item = itemStack.getItem()) instanceof ResourceKeyHolder) {
            ResourceKeyHolder keyHolder = (ResourceKeyHolder)item;
            if (vec3 != null) {
                SpawnConditionContext context = new SpawnConditionContext(level, entity, level.registryAccess(), BlockPos.containing((double)vec3.x, (double)vec3.y, (double)vec3.z), randomSource);
                Util.getRandomSafe(level.registryAccess().registryOrThrow(keyHolder.getResourceKey()).holders().filter(holder -> ((AbstractFishVariant)holder.value()).spawnSettings().fishing().isPresent() ? Util.allOf(((AbstractFishVariant)holder.value()).spawnSettings().fishing().get()).test(context) : Util.allOf(((AbstractFishVariant)holder.value()).spawnSettings().entity()).test(context)).toList(), (RandomSource)randomSource).ifPresent(holder -> itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)((CompoundTag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putString(keyHolder.getResourceKey().location().getPath(), holder.key().location().toString()))))));
            }
        }
        return itemStack;
    }

    public static ItemStack create(Item item, String registryPath, String variant) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)FOTItem.createCustomData(registryPath, variant));
        return itemStack;
    }

    public static CustomData createCustomData(String registryPath, String variant) {
        return CustomData.of((CompoundTag)((CompoundTag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putString(registryPath, variant))));
    }
}

