/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.trunkplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTTrunkPlacerTypes;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CoconutTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<CoconutTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(trunkPlacer -> trunkPlacer.baseHeight), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(trunkPlacer -> trunkPlacer.heightRandA), (App)IntProvider.codec((int)0, (int)16).fieldOf("medium_trunk_start").forGetter(trunkPlacer -> trunkPlacer.mediumTrunkStart), (App)IntProvider.codec((int)0, (int)32).fieldOf("medium_trunk_height").forGetter(trunkPlacer -> trunkPlacer.mediumTrunkHeight), (App)Codec.BOOL.fieldOf("increase_medium_trunk_by_one").forGetter(trunkPlacer -> trunkPlacer.increaseMediumTrunkByOne), (App)BlockStateProvider.CODEC.fieldOf("small_log").forGetter(trunkPlacer -> trunkPlacer.smallLog), (App)BlockStateProvider.CODEC.fieldOf("medium_log").forGetter(trunkPlacer -> trunkPlacer.mediumLog), (App)BlockStateProvider.CODEC.fieldOf("top_log").forGetter(trunkPlacer -> trunkPlacer.topLog)).apply((Applicative)instance, CoconutTrunkPlacer::new));
    private final IntProvider mediumTrunkStart;
    private final IntProvider mediumTrunkHeight;
    private final boolean increaseMediumTrunkByOne;
    private final BlockStateProvider smallLog;
    private final BlockStateProvider mediumLog;
    private final BlockStateProvider topLog;

    public CoconutTrunkPlacer(int baseHeight, int heightRandA, IntProvider mediumTrunkStart, IntProvider mediumTrunkHeight, boolean increaseMediumTrunkByOne, BlockStateProvider smallLog, BlockStateProvider mediumLog, BlockStateProvider topLog) {
        super(baseHeight, heightRandA, 0);
        this.mediumTrunkStart = mediumTrunkStart;
        this.mediumTrunkHeight = mediumTrunkHeight;
        this.increaseMediumTrunkByOne = increaseMediumTrunkByOne;
        this.smallLog = smallLog;
        this.mediumLog = mediumLog;
        this.topLog = topLog;
    }

    protected TrunkPlacerType<?> type() {
        return FOTTrunkPlacerTypes.COCONUT_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        CoconutTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        int mediumTrunkStart = this.mediumTrunkStart.sample(random);
        int mediumTrunkHeight = this.mediumTrunkHeight.sample(random);
        if (this.increaseMediumTrunkByOne && mediumTrunkStart == mediumTrunkHeight) {
            ++mediumTrunkHeight;
        }
        for (int height = 0; height < freeTreeHeight; ++height) {
            this.placeLog(level, blockSetter, random, pos.above(height), config, mediumTrunkStart, mediumTrunkHeight, height, height == freeTreeHeight - 1);
        }
        return List.of(new FoliagePlacer.FoliageAttachment(pos.above(freeTreeHeight), 0, false));
    }

    private void placeLog(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config, int mediumTrunkStart, int mediumTrunkHeight, int height, boolean isTop) {
        if (this.validTreePos(level, pos)) {
            BlockState blockState = config.trunkProvider.getState(random, pos);
            int maxMediumTrunkHeight = mediumTrunkStart + mediumTrunkHeight;
            if (isTop) {
                blockState = this.topLog.getState(random, pos);
            } else if (height >= mediumTrunkStart && height < maxMediumTrunkHeight) {
                blockState = this.mediumLog.getState(random, pos);
            } else if (height >= maxMediumTrunkHeight) {
                blockState = this.smallLog.getState(random, pos);
            }
            blockSetter.accept(pos, blockState);
        }
    }
}

