/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.feature.stateproviders.DirectionalRandomizedIntBooleanStateProvider;
import com.stevekung.fishofthieves.registry.FOTTreeDecoratorTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class DirectionalAttachedToLeavesDecorator
extends TreeDecorator {
    public static final MapCodec<DirectionalAttachedToLeavesDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(decorator -> decorator.exclusionRadiusXZ), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_y").forGetter(decorator -> decorator.exclusionRadiusY), (App)DirectionalRandomizedIntBooleanStateProvider.CODEC.fieldOf("block_provider").forGetter(decorator -> decorator.blockProvider), (App)Codec.intRange((int)1, (int)16).fieldOf("required_empty_blocks").forGetter(decorator -> decorator.requiredEmptyBlocks), (App)ExtraCodecs.nonEmptyList((Codec)Direction.CODEC.listOf()).fieldOf("directions").forGetter(decorator -> decorator.directions), (App)Codec.BOOL.fieldOf("opposite").forGetter(decorator -> decorator.opposite)).apply((Applicative)instance, DirectionalAttachedToLeavesDecorator::new));
    protected final float probability;
    protected final int exclusionRadiusXZ;
    protected final int exclusionRadiusY;
    protected final DirectionalRandomizedIntBooleanStateProvider blockProvider;
    protected final int requiredEmptyBlocks;
    protected final List<Direction> directions;
    protected final boolean opposite;

    public DirectionalAttachedToLeavesDecorator(float probability, int exclusionRadiusXZ, int exclusionRadiusY, DirectionalRandomizedIntBooleanStateProvider blockProvider, int requiredEmptyBlocks, List<Direction> directions, boolean opposite) {
        this.probability = probability;
        this.exclusionRadiusXZ = exclusionRadiusXZ;
        this.exclusionRadiusY = exclusionRadiusY;
        this.blockProvider = blockProvider;
        this.requiredEmptyBlocks = requiredEmptyBlocks;
        this.directions = directions;
        this.opposite = opposite;
    }

    public void place(TreeDecorator.Context context) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        RandomSource randomSource = context.random();
        for (BlockPos blockPos : Util.shuffledCopy((ObjectArrayList)context.leaves(), (RandomSource)randomSource)) {
            Direction direction;
            BlockPos blockPos2 = blockPos.relative(direction = (Direction)Util.getRandom(this.directions, (RandomSource)randomSource));
            if (set.contains(blockPos2) || !(randomSource.nextFloat() < this.probability) || !this.hasRequiredEmptyBlocks(context, blockPos, direction)) continue;
            BlockPos blockPos3 = blockPos2.offset(-this.exclusionRadiusXZ, -this.exclusionRadiusY, -this.exclusionRadiusXZ);
            BlockPos blockPos4 = blockPos2.offset(this.exclusionRadiusXZ, this.exclusionRadiusY, this.exclusionRadiusXZ);
            for (BlockPos blockPos5 : BlockPos.betweenClosed((BlockPos)blockPos3, (BlockPos)blockPos4)) {
                set.add(blockPos5.immutable());
            }
            context.setBlock(blockPos2, this.blockProvider.getState(randomSource, blockPos2, this.opposite ? direction.getOpposite() : direction));
        }
    }

    private boolean hasRequiredEmptyBlocks(TreeDecorator.Context context, BlockPos pos, Direction direction) {
        for (int i = 1; i <= this.requiredEmptyBlocks; ++i) {
            BlockPos blockPos = pos.relative(direction, i);
            if (context.isAir(blockPos)) continue;
            return false;
        }
        return true;
    }

    protected TreeDecoratorType<?> type() {
        return FOTTreeDecoratorTypes.DIRECTIONAL_ATTACHED_TO_LEAVES;
    }
}

