/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.CoconutFruitBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.FOTTreeDecoratorTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CoconutDecorator
extends TreeDecorator {
    public static final MapCodec<CoconutDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("coconut_probability").forGetter(decorator -> Float.valueOf(decorator.coconutProbability)), (App)Codec.intRange((int)0, (int)16).fieldOf("y_to_grow_coconut_at").forGetter(decorator -> decorator.yToGrowCoconutAt)).apply((Applicative)instance, CoconutDecorator::new));
    private final float probability;
    private final float coconutProbability;
    private final int yToGrowCoconutAt;

    public CoconutDecorator(float probability, float coconutProbability, int yToGrowCoconutAt) {
        this.probability = probability;
        this.coconutProbability = coconutProbability;
        this.yToGrowCoconutAt = yToGrowCoconutAt;
    }

    protected TreeDecoratorType<?> type() {
        return FOTTreeDecoratorTypes.COCONUT;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomSource = context.random();
        if (!(randomSource.nextFloat() >= this.probability)) {
            ObjectArrayList list = context.logs();
            int yAtStart = ((BlockPos)list.getFirst()).getY();
            Integer maxY = Collections.max(list.stream().map(blockPos -> blockPos.getY() - yAtStart).toList());
            int yToGrowCoconutAt = maxY - this.yToGrowCoconutAt;
            list.stream().filter(blockPos -> blockPos.getY() - yAtStart == yToGrowCoconutAt).findFirst().ifPresent(blockPos -> {
                Predicate<BlockState> canGrow = blockState -> blockState.is(FOTTags.Blocks.COCONUT_GROWABLE_LOG_SPAWNABLE);
                if (context.level().isStateAtPosition(blockPos.above(), canGrow) && context.level().isStateAtPosition(blockPos.below(), canGrow)) {
                    context.setBlock(blockPos, FOTBlocks.COCONUT_FRUIT_GROWABLE_LOG.defaultBlockState());
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        Direction opposite;
                        BlockPos posAroundLog;
                        if (!(randomSource.nextFloat() <= this.coconutProbability) || !context.isAir(posAroundLog = blockPos.offset((opposite = direction.getOpposite()).getStepX(), 0, opposite.getStepZ()))) continue;
                        context.setBlock(posAroundLog, (BlockState)((BlockState)FOTBlocks.COCONUT_FRUIT.defaultBlockState().setValue((Property)CoconutFruitBlock.AGE, (Comparable)Integer.valueOf(randomSource.nextInt(3)))).setValue((Property)CoconutFruitBlock.FACING, (Comparable)direction));
                    }
                }
            });
        }
    }
}

