/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.BananaShootsPlantBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTreeDecoratorTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class BananaShootsDecorator
extends TreeDecorator {
    public static final MapCodec<BananaShootsDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability))).apply((Applicative)instance, BananaShootsDecorator::new));
    private final float probability;

    public BananaShootsDecorator(float probability) {
        this.probability = probability;
    }

    protected TreeDecoratorType<?> type() {
        return FOTTreeDecoratorTypes.BANANA_SHOOTS;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomSource = context.random();
        BlockPos blockPos = (BlockPos)context.logs().getFirst();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            Direction opposite;
            BlockPos posAroundLog;
            if (randomSource.nextFloat() >= this.probability || !context.isAir(posAroundLog = blockPos.offset((opposite = direction.getOpposite()).getStepX(), 0, opposite.getStepZ()))) continue;
            context.setBlock(posAroundLog, (BlockState)FOTBlocks.BANANA_SHOOTS_PLANT.defaultBlockState().setValue((Property)BananaShootsPlantBlock.FACING, (Comparable)direction));
        }
    }
}

