/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTFoliagePlacerTypes;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CoconutFrondsPlacer
extends FoliagePlacer {
    public static final MapCodec<CoconutFrondsPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CoconutFrondsPlacer.frondsPart(instance).apply((Applicative)instance, CoconutFrondsPlacer::new));
    final int height;
    final int maxLeavesDistanceFromLocalY;
    final BlockStateProvider topLeavesState;
    final BlockStateProvider middleLeavesState;
    final BlockStateProvider tailLeavesState;
    final List<Pair<Integer, Integer>> reduceLeavesDistance;

    static <P extends CoconutFrondsPlacer> Products.P6<RecordCodecBuilder.Mu<P>, Integer, Integer, BlockStateProvider, BlockStateProvider, BlockStateProvider, List<Pair<Integer, Integer>>> frondsPart(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)Codec.intRange((int)0, (int)8).fieldOf("height").forGetter(placer -> placer.height)).and((App)Codec.intRange((int)0, (int)8).fieldOf("max_leaves_distance_from_local_y").forGetter(placer -> placer.maxLeavesDistanceFromLocalY)).and((App)BlockStateProvider.CODEC.fieldOf("top_leaves_state").forGetter(placer -> placer.topLeavesState)).and((App)BlockStateProvider.CODEC.fieldOf("middle_leaves_state").forGetter(placer -> placer.middleLeavesState)).and((App)BlockStateProvider.CODEC.fieldOf("tail_leaves_state").forGetter(placer -> placer.tailLeavesState)).and((App)Codec.mapPair((MapCodec)Codec.intRange((int)0, (int)16).fieldOf("at_tree_height"), (MapCodec)Codec.intRange((int)0, (int)8).fieldOf("reduce_by")).codec().listOf().optionalFieldOf("reduce_leaves_distance", List.of()).forGetter(placer -> placer.reduceLeavesDistance));
    }

    public CoconutFrondsPlacer(int height, int maxLeavesDistanceFromLocalY, BlockStateProvider topLeavesState, BlockStateProvider middleLeavesState, BlockStateProvider tailLeavesState, List<Pair<Integer, Integer>> reduceLeavesDistance) {
        super((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0));
        this.height = height;
        this.maxLeavesDistanceFromLocalY = maxLeavesDistanceFromLocalY;
        this.topLeavesState = topLeavesState;
        this.middleLeavesState = middleLeavesState;
        this.tailLeavesState = tailLeavesState;
        this.reduceLeavesDistance = reduceLeavesDistance;
    }

    @SafeVarargs
    public CoconutFrondsPlacer(int height, int maxLeavesDistanceFromLocalY, BlockStateProvider topLeavesState, BlockStateProvider middleLeavesState, BlockStateProvider tailLeavesState, Pair<Integer, Integer> ... reduceLeavesDistance) {
        this(height, maxLeavesDistanceFromLocalY, topLeavesState, middleLeavesState, tailLeavesState, Arrays.stream(reduceLeavesDistance).toList());
    }

    protected FoliagePlacerType<?> type() {
        return FOTFoliagePlacerTypes.COCONUT_FRONDS_PLACER;
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = attachment.pos();
        if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            return;
        }
        for (int localY = offset; localY >= offset - foliageHeight; --localY) {
            if (localY == 0) {
                this.placeTopLeaves(level, pos, random, blockSetter);
                continue;
            }
            int maxLeavesDistanceFromLocalY = this.maxLeavesDistanceFromLocalY - localY + 1;
            for (Pair<Integer, Integer> pair : this.reduceLeavesDistance) {
                if (maxFreeTreeHeight != (Integer)pair.getFirst()) continue;
                maxLeavesDistanceFromLocalY -= ((Integer)pair.getSecond()).intValue();
            }
            this.placeLeavesHorizontalDirections(level, pos, random, config, blockSetter, maxLeavesDistanceFromLocalY, localY);
        }
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return this.height;
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && (random.nextInt(2) == 0 || localY == 0);
    }

    private void placeTopLeaves(LevelSimulatedReader level, BlockPos blockPos, RandomSource random, FoliagePlacer.FoliageSetter blockSetter) {
        if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)blockPos)) {
            BlockState blockState = this.topLeavesState.getState(random, blockPos);
            if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(blockPos, fluidState -> fluidState.isSourceOfType((Fluid)Fluids.WATER))));
            }
            blockSetter.set(blockPos, blockState);
        }
    }

    private void placeLeavesHorizontalDirections(LevelSimulatedReader level, BlockPos blockPos, RandomSource random, TreeConfiguration config, FoliagePlacer.FoliageSetter blockSetter, int maxLeavesDistanceFromLocalY, int localY) {
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.mutable();
        block0: for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState middleLeavesState;
            Direction opposite = direction.getOpposite();
            BlockState leavesBlockState = config.foliageProvider.getState(random, blockPos);
            if (leavesBlockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                leavesBlockState = (BlockState)leavesBlockState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)opposite);
            }
            if (leavesBlockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                leavesBlockState = (BlockState)leavesBlockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(blockPos, fluidState -> fluidState.isSourceOfType((Fluid)Fluids.WATER))));
            }
            if (maxLeavesDistanceFromLocalY == 1) {
                BlockPos posAroundLog = mutableBlockPos.offset(opposite.getStepX(), localY, opposite.getStepZ());
                if (!this.isAir(level, posAroundLog)) continue;
                blockSetter.set(posAroundLog, leavesBlockState);
                continue;
            }
            BlockState tailLeavesState = this.tailLeavesState.getState(random, blockPos);
            if (tailLeavesState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                tailLeavesState = (BlockState)tailLeavesState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)opposite);
            }
            if ((middleLeavesState = this.middleLeavesState.getState(random, blockPos)).hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                middleLeavesState = (BlockState)middleLeavesState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)opposite);
            }
            for (int i = 1; i <= maxLeavesDistanceFromLocalY; ++i) {
                BlockPos posAroundLog = mutableBlockPos.offset(opposite.getStepX() * i, localY, opposite.getStepZ() * i);
                if (this.isAir(level, posAroundLog)) {
                    if (i > 1 && i < maxLeavesDistanceFromLocalY) {
                        blockSetter.set(posAroundLog, middleLeavesState);
                        continue;
                    }
                    if (i == maxLeavesDistanceFromLocalY) {
                        blockSetter.set(posAroundLog, tailLeavesState);
                        continue;
                    }
                    blockSetter.set(posAroundLog, leavesBlockState);
                    continue;
                }
                BlockPos previousLeavesPos = mutableBlockPos.offset(opposite.getStepX() * (i - 1), localY, opposite.getStepZ() * (i - 1));
                if (!level.isStateAtPosition(previousLeavesPos, middleLeavesState::equals)) continue block0;
                blockSetter.set(previousLeavesPos, tailLeavesState);
                continue block0;
            }
        }
    }

    private boolean isAir(LevelSimulatedReader level, BlockPos blockPos) {
        return level.isStateAtPosition(blockPos, BlockBehaviour.BlockStateBase::isAir);
    }
}

