/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.BananaLeavesBlock;
import com.stevekung.fishofthieves.registry.FOTFoliagePlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BananaLeavesPlacer
extends FoliagePlacer {
    public static final MapCodec<BananaLeavesPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> BananaLeavesPlacer.frondsPart(instance).apply((Applicative)instance, BananaLeavesPlacer::new));
    final float oneLeavesChance;
    final BlockStateProvider topLeavesState;
    final BlockStateProvider tailLeavesState;

    static <P extends BananaLeavesPlacer> Products.P3<RecordCodecBuilder.Mu<P>, Float, BlockStateProvider, BlockStateProvider> frondsPart(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("one_leaves_chance").forGetter(placer -> Float.valueOf(placer.oneLeavesChance))).and((App)BlockStateProvider.CODEC.fieldOf("top_leaves_state").forGetter(placer -> placer.topLeavesState)).and((App)BlockStateProvider.CODEC.fieldOf("tail_leaves_state").forGetter(placer -> placer.tailLeavesState));
    }

    public BananaLeavesPlacer(float oneLeavesChance, BlockStateProvider topLeavesState, BlockStateProvider tailLeavesState) {
        super((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0));
        this.oneLeavesChance = oneLeavesChance;
        this.topLeavesState = topLeavesState;
        this.tailLeavesState = tailLeavesState;
    }

    protected FoliagePlacerType<?> type() {
        return FOTFoliagePlacerTypes.BANANA_LEAVES_PLACER;
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = attachment.pos();
        if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            return;
        }
        for (int localY = offset; localY >= offset - 1; --localY) {
            if (localY == 0) {
                this.placeTopLeaves(level, pos, random, blockSetter);
                continue;
            }
            BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Direction opposite = direction.getOpposite();
                BlockPos posAroundLog = mutableBlockPos.offset(opposite.getStepX(), localY, opposite.getStepZ());
                if (!this.isAir(level, posAroundLog) || !this.isAir(level, posAroundLog.relative(opposite))) continue;
                boolean singleLeaves = random.nextFloat() < this.oneLeavesChance;
                blockSetter.set(posAroundLog, this.applyAdditionalState(level, posAroundLog, config.foliageProvider.getState(random, pos), opposite, singleLeaves));
                blockSetter.set(posAroundLog.relative(opposite), this.applyAdditionalState(level, posAroundLog, this.tailLeavesState.getState(random, pos), opposite, singleLeaves));
            }
        }
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return 1;
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && (random.nextInt(2) == 0 || localY == 0);
    }

    private boolean isAir(LevelSimulatedReader level, BlockPos blockPos) {
        return level.isStateAtPosition(blockPos, BlockBehaviour.BlockStateBase::isAir);
    }

    private void placeTopLeaves(LevelSimulatedReader level, BlockPos blockPos, RandomSource random, FoliagePlacer.FoliageSetter blockSetter) {
        if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)blockPos)) {
            BlockState blockState = this.topLeavesState.getState(random, blockPos);
            if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(blockPos, fluidState -> fluidState.isSourceOfType((Fluid)Fluids.WATER))));
            }
            blockSetter.set(blockPos, blockState);
        }
    }

    private BlockState applyAdditionalState(LevelSimulatedReader level, BlockPos blockPos, BlockState blockState, Direction opposite, boolean singleLeaves) {
        if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(blockPos, fluidState -> fluidState.isSourceOfType((Fluid)Fluids.WATER))));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)opposite);
        }
        if (blockState.hasProperty((Property)BananaLeavesBlock.COUNT)) {
            blockState = (BlockState)blockState.setValue((Property)BananaLeavesBlock.COUNT, (Comparable)Integer.valueOf(singleLeaves ? 1 : 2));
        }
        return blockState;
    }
}

