/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.NeverCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.registry.FOTSpawnConditions;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;

public interface AbstractFishVariant {
    public static final Comparator<Holder<? extends AbstractFishVariant>> COMPARATOR = Comparator.comparing(Holder::value, Comparator.comparingInt(AbstractFishVariant::order));

    public int order();

    public String name();

    public ResourceLocation texture();

    public ResourceLocation fullTexture();

    public Optional<ResourceLocation> fullGlowTexture();

    public Optional<ResourceLocation> glowTexture();

    public Optional<Boolean> treasured();

    public SpawnSettings spawnSettings();

    public static <T extends AbstractFishVariant> Codec<T> simpleCodec(Function6<String, ResourceLocation, Optional<ResourceLocation>, Optional<Boolean>, SpawnSettings, Integer, T> factory) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("name").forGetter(AbstractFishVariant::name), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(AbstractFishVariant::texture), (App)ResourceLocation.CODEC.optionalFieldOf("glow_texture").forGetter(AbstractFishVariant::glowTexture), (App)Codec.BOOL.optionalFieldOf("treasured").forGetter(AbstractFishVariant::treasured), (App)SpawnSettings.CODEC.optionalFieldOf("spawn_settings", (Object)new SpawnSettings(List.of(), Optional.empty())).forGetter(AbstractFishVariant::spawnSettings), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("order").forGetter(AbstractFishVariant::order)).apply((Applicative)instance, factory));
    }

    public static <T extends AbstractFishVariant> Codec<T> networkCodec(Function5<String, ResourceLocation, Optional<ResourceLocation>, Optional<Boolean>, Integer, T> factory) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("name").forGetter(AbstractFishVariant::name), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(AbstractFishVariant::texture), (App)ResourceLocation.CODEC.optionalFieldOf("glow_texture").forGetter(AbstractFishVariant::glowTexture), (App)Codec.BOOL.optionalFieldOf("treasured").forGetter(AbstractFishVariant::treasured), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("order").forGetter(AbstractFishVariant::order)).apply((Applicative)instance, factory));
    }

    public static ResourceLocation fullTextureId(ResourceLocation texture) {
        return texture.withPath(string -> "textures/" + string + ".png");
    }

    public static <T extends AbstractFishVariant> Holder<T> getSpawnVariant(ServerLevel serverLevel, RegistryAccess registryAccess, ResourceKey<? extends Registry<? extends T>> registryKey, ResourceKey<T> defaultKey, LivingEntity livingEntity, boolean fromBucket) {
        Registry registry = registryAccess.registryOrThrow(registryKey);
        SpawnConditionContext context = new SpawnConditionContext(serverLevel, null, registryAccess, livingEntity.blockPosition(), livingEntity.getRandom());
        Optional muha = Util.getRandomSafe(registry.holders().filter(variant -> fromBucket || Util.allOf(((AbstractFishVariant)variant.value()).spawnSettings().entity()).test(context)).toList(), (RandomSource)livingEntity.getRandom());
        return (Holder)muha.orElseGet(() -> registry.getHolderOrThrow(defaultKey));
    }

    public record SpawnSettings(List<SpawnCondition> entity, Optional<List<SpawnCondition>> fishing) {
        public static final Codec<SpawnSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FOTSpawnConditions.DIRECT_CODEC.listOf().optionalFieldOf("entity", List.of()).forGetter(SpawnSettings::entity), (App)FOTSpawnConditions.DIRECT_CODEC.listOf().optionalFieldOf("fishing").forGetter(SpawnSettings::fishing)).apply((Applicative)instance, SpawnSettings::new));
        public static final SpawnSettings EMPTY = new SpawnSettings(List.of(), Optional.empty());
    }

    public record RegisterContext<T>(String entityName, Function6<String, ResourceLocation, Optional<ResourceLocation>, Optional<Boolean>, SpawnSettings, Integer, T> factory) {
        public static <T> RegisterContext<T> create(String entityName, Function6<String, ResourceLocation, Optional<ResourceLocation>, Optional<Boolean>, SpawnSettings, Integer, T> factory) {
            return new RegisterContext<T>(entityName, factory);
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int order, SpawnCondition ... conditions) {
            this.register(context, key, name, order, false, Optional.empty(), List.of(conditions), List.of());
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int order, List<SpawnCondition> conditions, List<SpawnCondition> fishingOverride) {
            this.register(context, key, name, order, false, Optional.empty(), conditions, fishingOverride);
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int order, boolean glow, SpawnCondition ... conditions) {
            this.register(context, key, name, order, glow, Optional.empty(), List.of(conditions), List.of());
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int order, boolean glow, boolean treasured) {
            this.register(context, key, name, order, glow, Optional.of(treasured), List.of(NeverCondition.never().build()), List.of());
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int order, boolean glow, Optional<Boolean> treasured, List<SpawnCondition> conditions, List<SpawnCondition> fishingOverride) {
            String treasuredPath = treasured.isPresent() ? "treasured/" : "";
            ResourceLocation texture = FishOfThieves.id("entity/" + this.entityName + "/" + treasuredPath + name);
            ResourceLocation glowTexture = FishOfThieves.id("entity/" + this.entityName + "/" + treasuredPath + name + "_glow");
            context.register(key, this.factory.apply((Object)name, (Object)texture, glow ? Optional.of(glowTexture) : Optional.empty(), treasured, (Object)new SpawnSettings(conditions, fishingOverride.isEmpty() ? Optional.empty() : Optional.of(fishingOverride)), (Object)order));
        }
    }
}

