/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.shoal;

import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.block.ShoalBlock;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.shoal.ShoalFishData;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTCriteriaTriggers;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Shoal
extends Entity {
    private static final List<EntityType<?>> COMMON_FISH = List.of(FOTEntities.SPLASHTAIL, FOTEntities.PONDIE, FOTEntities.ANCIENTSCALE, FOTEntities.ISLEHOPPER, FOTEntities.PLENTIFIN, FOTEntities.WILDSPLASH);
    private static final List<EntityType<?>> TIER_1_FISH_QUEST = List.of(FOTEntities.PONDIE, FOTEntities.ANCIENTSCALE, FOTEntities.WRECKER, FOTEntities.DEVILFISH, FOTEntities.ISLEHOPPER);
    private static final List<EntityType<?>> TIER_2_FISH_QUEST = List.of(FOTEntities.SPLASHTAIL, FOTEntities.WILDSPLASH, FOTEntities.BATTLEGILL, FOTEntities.PLENTIFIN, FOTEntities.STORMFISH);
    private static final EntityDataAccessor<Boolean> TREASURED = SynchedEntityData.defineId(Shoal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final String SHOAL_FISH_TAG = "shoal_fish";
    public static final String LIFETIME_TAG = "lifetime";
    public static final String NATURAL_TAG = "natural";
    public static final String TREASURED_TAG = "treasured";
    public static final String PARTICIPATES_TAG = "participates";
    public static final String FILLED_MAP_TREASURED_FISH = "filled_map.fishofthieves_treasured_fish";
    private final List<ShoalFishData> shoalFishData = new ArrayList<ShoalFishData>();
    private final Set<UUID> participates = new HashSet<UUID>();
    private long expiredAt = -1L;
    private List<LivingEntity> shoalFishClient = new ArrayList<LivingEntity>();

    public Shoal(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TREASURED, (Object)false);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.shoalFishData.clear();
        ListTag shoalFishListTag = compound.getList(SHOAL_FISH_TAG, 10);
        for (int i = 0; i < shoalFishListTag.size(); ++i) {
            CompoundTag compoundTag = shoalFishListTag.getCompound(i);
            if (!compoundTag.contains("id", 8) || compoundTag.getString("id").isEmpty()) {
                return;
            }
            UUID uuid = compoundTag.hasUUID("uuid") ? compoundTag.getUUID("uuid") : UUID.randomUUID();
            this.shoalFishData.add(new ShoalFishData(compoundTag.getString("id"), uuid, compoundTag.getCompound("data")));
        }
        if (compound.contains(LIFETIME_TAG, 4)) {
            this.expiredAt = compound.getLong(LIFETIME_TAG);
        }
        if (compound.contains(TREASURED_TAG, 1)) {
            this.setTreasured(compound.getBoolean(TREASURED_TAG));
        }
        ListTag participatesListTag = compound.getList(PARTICIPATES_TAG, 10);
        for (int i = 0; i < participatesListTag.size(); ++i) {
            CompoundTag compoundTag = participatesListTag.getCompound(i);
            if (!compoundTag.hasUUID("UUID")) continue;
            this.participates.add(compoundTag.getUUID("UUID"));
        }
        if (!this.level().isClientSide() && compound.contains(NATURAL_TAG) && compound.getBoolean(NATURAL_TAG)) {
            this.createNaturalSpawn(false);
        }
        FOTPlatform.syncClientShoalFish(this, false);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        ListTag shoalFishListTag = new ListTag();
        for (ShoalFishData fish : this.shoalFishData) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("id", fish.id());
            compoundTag.putUUID("uuid", fish.uuid());
            compoundTag.put("data", (Tag)fish.data());
            shoalFishListTag.add((Object)compoundTag);
        }
        compound.put(SHOAL_FISH_TAG, (Tag)shoalFishListTag);
        if (this.expiredAt > 0L) {
            compound.putLong(LIFETIME_TAG, this.expiredAt);
        }
        compound.putBoolean(TREASURED_TAG, this.isTreasured());
        ListTag participatesListTag = new ListTag();
        for (UUID uuid : this.participates) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putUUID("UUID", uuid);
            participatesListTag.add((Object)compoundTag);
        }
        compound.put(PARTICIPATES_TAG, (Tag)participatesListTag);
    }

    public boolean canBeHitByProjectile() {
        return false;
    }

    public boolean skipAttackInteraction(Entity entity) {
        return true;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            int soundChance;
            BlockState blockState = this.level().getBlockState(this.blockPosition());
            boolean canSurvive = ShoalBlock.canSurvive((LevelReader)this.level(), this.blockPosition());
            if ((this.level().getGameTime() % 20L == 0L && !canSurvive || !this.isTreasured() && this.level().getGameTime() >= this.expiredAt || this.shoalFishData.isEmpty() || !blockState.is(FOTBlocks.SHOAL)) && !this.isInvulnerable()) {
                this.destroy();
            }
            if (this.random.nextInt(4) == 0) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SPLASH, this.getX(), this.getY(0.8), this.getZ(), 10, (double)(this.getBbWidth() / 3.0f), (double)(this.getBbHeight() / 5.0f), (double)(this.getBbWidth() / 3.0f), 0.0);
            }
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), this.getY(0.5), this.getZ(), 1, (double)(this.getBbWidth() / 2.0f), (double)(this.getBbHeight() / 5.0f), (double)(this.getBbWidth() / 2.0f), 0.0);
            if (!this.shoalFishData.isEmpty() && this.random.nextInt(Math.max(15, soundChance = 40 / this.shoalFishData.size())) == 0) {
                this.playSound(SoundEvents.FISH_SWIM, 0.1f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
            }
        }
    }

    public void move(MoverType type, Vec3 pos) {
        if (type == MoverType.PISTON) {
            this.destroy();
        }
        super.move(type, pos);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        FOTPlatform.requestServerShoalFish(this);
    }

    public void kill() {
        super.kill();
        this.destroyShoalBlock();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = 64.0 * Shoal.getViewScale();
        return distance < d0 * d0;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (damageSource.is(DamageTypeTags.IS_EXPLOSION)) {
            this.destroy();
        }
        return super.hurt(damageSource, amount);
    }

    public void setTreasured(boolean treasured) {
        this.getEntityData().set(TREASURED, (Object)treasured);
    }

    public boolean isTreasured() {
        return (Boolean)this.getEntityData().get(TREASURED);
    }

    public void destroy() {
        this.discard();
        this.destroyShoalBlock();
    }

    public void syncClientShoalFish(List<ShoalFishData> shoalFishData, boolean forcedUpdate) {
        block3: {
            block2: {
                if (this.shoalFishClient.isEmpty() || this.shoalFishClient.size() != shoalFishData.size()) break block2;
                if (!forcedUpdate) break block3;
            }
            this.shoalFishClient = shoalFishData.stream().map(shoalFishData1 -> {
                CompoundTag compoundTag = shoalFishData1.data();
                compoundTag.putString("id", shoalFishData1.id());
                return EntityType.loadEntityRecursive((CompoundTag)compoundTag, (Level)this.level(), Function.identity());
            }).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).peek(livingEntity -> {
                livingEntity.wasTouchingWater = true;
            }).toList();
        }
    }

    public List<ShoalFishData> getShoalFish() {
        return this.shoalFishData;
    }

    @Nullable
    public LivingEntity getRandomFishInShoal() {
        ShoalFishData shoalFish = (ShoalFishData)Util.getRandom(this.shoalFishData, (RandomSource)this.random);
        UUID uuid = shoalFish.uuid();
        CompoundTag compoundTag = shoalFish.data();
        compoundTag.putString("id", shoalFish.id());
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)compoundTag, (Level)this.level(), Function.identity());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.shoalFishData.removeIf(shoalFishData1 -> shoalFishData1.uuid().equals(uuid));
            FOTPlatform.syncClientShoalFish(this, false);
            if (this.shoalFishData.isEmpty()) {
                for (UUID participate : this.participates) {
                    Player player = this.level().getPlayerByUUID(participate);
                    if (!(player instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    FOTCriteriaTriggers.PARTICIPATE_SHOAL.trigger(serverPlayer);
                }
                this.destroy();
            }
            if (livingEntity instanceof Mob) {
                ThievesFish thievesFish;
                Mob mob = (Mob)livingEntity;
                if (livingEntity instanceof ThievesFish && (thievesFish = (ThievesFish)livingEntity).isTreasured()) {
                    mob.setPersistenceRequired();
                }
            }
            return livingEntity;
        }
        FishOfThieves.LOGGER.warn("ShoalFishData with entity id {} is not a living entity", (Object)shoalFish.id());
        return null;
    }

    public List<LivingEntity> getShoalFishClient() {
        return this.shoalFishClient;
    }

    public void createNaturalSpawn(boolean clientSync) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ArrayList commonFish = new ArrayList(COMMON_FISH);
        if (this.level().isThundering()) {
            commonFish.add(FOTEntities.STORMFISH);
        }
        for (EntityType<?> entityType : Shoal.pickRandom(commonFish, 3)) {
            Entity entity = entityType.create((Level)serverLevel);
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            CompoundTag compoundTag = new CompoundTag();
            mob.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.NATURAL, null);
            CompoundTag tempTag = mob.saveWithoutId(new CompoundTag());
            if (mob instanceof ThievesFish) {
                compoundTag.putString("variant", tempTag.getString("variant"));
                compoundTag.putBoolean("Trophy", this.random.nextFloat() < FishOfThieves.CONFIG.spawnRate.trophyProbability);
            }
            this.shoalFishData.add(new ShoalFishData(BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType()).toString(), UUID.randomUUID(), compoundTag));
        }
        this.expiredAt = this.level().getGameTime() + (long)FishOfThieves.CONFIG.shoal.maxLifetimeDay * 24000L;
        if (clientSync) {
            FOTPlatform.syncClientShoalFish(this, false);
        }
    }

    public void createTreasuredSpawn(int tier) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int prevShoalSize = this.shoalFishData.size();
        this.shoalFishData.clear();
        for (EntityType<?> entityType : Shoal.pickRandom(tier == 1 ? TIER_1_FISH_QUEST : TIER_2_FISH_QUEST, prevShoalSize)) {
            Entity entity = entityType.create((Level)serverLevel);
            if (!(entity instanceof ThievesFish)) continue;
            ThievesFish thievesFish = (ThievesFish)entity;
            CompoundTag compoundTag = new CompoundTag();
            ResourceLocation key = (ResourceLocation)Util.getRandom(this.registryAccess().registryOrThrow(thievesFish.getRegistryKey()).entrySet().stream().filter(entry -> ((AbstractFishVariant)entry.getValue()).treasured().isPresent()).map(entry -> ((ResourceKey)entry.getKey()).location()).toList(), (RandomSource)this.random);
            compoundTag.putString("variant", key.toString());
            compoundTag.putBoolean("Trophy", true);
            this.shoalFishData.add(new ShoalFishData(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString(), UUID.randomUUID(), compoundTag));
        }
        this.expiredAt = -1L;
        FOTPlatform.syncClientShoalFish(this, true);
    }

    public void addParticipatePlayer(UUID uuid) {
        this.participates.add(uuid);
    }

    public void setExpiredAt(long expiredAt) {
        this.expiredAt = expiredAt;
    }

    public static void setTreasuredShoal(Level level, BlockPos blockPos, int tier) {
        level.setBlock(blockPos, (BlockState)FOTBlocks.SHOAL.defaultBlockState().setValue((Property)ShoalBlock.TREASURED, (Comparable)Boolean.valueOf(true)), 2);
        List shoals = level.getEntitiesOfClass(Shoal.class, new AABB(blockPos).inflate(1.0));
        if (!shoals.isEmpty()) {
            Shoal shoal = (Shoal)((Object)shoals.getFirst());
            shoal.createTreasuredSpawn(tier);
            shoal.setTreasured(true);
        }
    }

    private void destroyShoalBlock() {
        BlockPos blockPos = this.blockPosition();
        BlockState blockState = this.level().getBlockState(blockPos);
        if (blockState.is(FOTBlocks.SHOAL)) {
            this.level().setBlock(blockPos, Blocks.WATER.defaultBlockState(), 2);
        }
        if (!this.level().isClientSide()) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY(1.0), this.getZ(), 10, (double)(this.getBbWidth() / 5.0f), (double)(this.getBbHeight() / 2.0f), (double)(this.getBbWidth() / 5.0f), 0.0);
            this.playSound(FOTSoundEvents.SHOAL_DEPLETE, 1.0f, 0.75f);
        }
        if (FishOfThieves.CONFIG.debug.spawnBeaconAtShoal && FOTPlatform.isDevelopment()) {
            for (BlockPos blockPos1 : BlockPos.betweenClosed((BlockPos)blockPos.offset(-1, -4, -1), (BlockPos)blockPos.offset(1, -4, 1))) {
                if (!this.level().getBlockState(blockPos1).is(Blocks.IRON_BLOCK)) continue;
                this.level().setBlock(blockPos1, Blocks.WATER.defaultBlockState(), 3);
            }
            if (this.level().getBlockState(blockPos.below(3)).is(Blocks.BEACON)) {
                this.level().setBlock(blockPos.below(3), Blocks.WATER.defaultBlockState(), 3);
            }
        }
    }

    private static List<? extends EntityType<?>> pickRandom(List<EntityType<?>> list, int count) {
        return new Random().ints(0, list.size()).distinct().limit(count).mapToObj(list::get).toList();
    }
}

