/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionType;
import com.stevekung.fishofthieves.registry.FOTSpawnConditions;
import net.minecraft.advancements.critereon.MinMaxBounds;

public record MoonBrightnessCondition(MinMaxBounds.Doubles brightness) implements SpawnCondition
{
    public static final MapCodec<MoonBrightnessCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinMaxBounds.Doubles.CODEC.fieldOf("brightness").forGetter(MoonBrightnessCondition::brightness)).apply((Applicative)instance, MoonBrightnessCondition::new));

    @Override
    public SpawnConditionType getType() {
        return FOTSpawnConditions.MOON_BRIGHTNESS;
    }

    @Override
    public boolean test(SpawnConditionContext context) {
        return this.brightness.matches((double)context.level().getMoonBrightness());
    }

    public static SpawnCondition.Builder moonBrightness(MinMaxBounds.Doubles brightness) {
        return () -> new MoonBrightnessCondition(brightness);
    }
}

