/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionType;
import com.stevekung.fishofthieves.registry.FOTSpawnConditions;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;

public record LivingEntityHasEffectCondition(HolderSet<MobEffect> mobEffect) implements SpawnCondition
{
    public static final MapCodec<LivingEntityHasEffectCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.MOB_EFFECT).fieldOf("mob_effect").forGetter(LivingEntityHasEffectCondition::mobEffect)).apply((Applicative)instance, LivingEntityHasEffectCondition::new));

    @Override
    public SpawnConditionType getType() {
        return FOTSpawnConditions.LIVING_ENTITY_HAS_EFFECT;
    }

    @Override
    public boolean test(SpawnConditionContext context) {
        LivingEntity livingEntity;
        Object object = context.entity();
        if (object instanceof LivingEntity && (object = (livingEntity = (LivingEntity)object).getActiveEffectsMap().keySet().iterator()).hasNext()) {
            Holder holder = (Holder)object.next();
            return this.mobEffect.contains(holder);
        }
        return false;
    }

    public static SpawnCondition.Builder effect(HolderSet<MobEffect> mobEffect) {
        return () -> new LivingEntityHasEffectCondition(mobEffect);
    }
}

