/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.ai.WreckerAi;
import com.stevekung.fishofthieves.entity.variant.WreckerVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.WreckerVariants;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Nullable;

public class Wrecker
extends AbstractThievesFish<WreckerVariant> {
    private static final EntityDataAccessor<Holder<WreckerVariant>> VARIANT = SynchedEntityData.defineId(Wrecker.class, FOTDataSerializers.WRECKER_VARIANT);
    private static final List<SensorType<? extends Sensor<? super Wrecker>>> SENSOR_TYPES = List.of(SensorType.NEAREST_LIVING_ENTITIES, FOTSensorTypes.NON_CREATIVE_NEAREST_PLAYERS, SensorType.HURT_BY, FOTSensorTypes.EARTHWORMS_THIEVES_FISH_TEMPTATIONS, FOTSensorTypes.NEAREST_WRECKER_LOCATED, FOTSensorTypes.NEAREST_MAGMA_BLOCK, FOTSensorTypes.WRECKER_ATTACKABLES, FOTSensorTypes.LOW_BRIGHTNESS);
    private static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.NEAREST_REPELLENT, FOTMemoryModuleTypes.NEAREST_WRECKER_LOCATED, FOTMemoryModuleTypes.NEAREST_LOW_BRIGHTNESS, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING, MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, FOTMemoryModuleTypes.BREACHED_TICK);

    public Wrecker(EntityType<? extends Wrecker> entityType, Level level) {
        super(entityType, level, FOTRegistries.WRECKER_VARIANT, WreckerVariants.ROSE);
    }

    protected Brain.Provider<Wrecker> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return WreckerAi.makeBrain((Brain<Wrecker>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Wrecker> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep() {
        this.level().getProfiler().push("wreckerBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().popPush("wreckerActivityUpdate");
        WreckerAi.updateActivity(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)this.registryAccess().registryOrThrow(FOTRegistries.WRECKER_VARIANT).getHolderOrThrow(WreckerVariants.ROSE));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        WreckerAi.initMemories(this);
    }

    public Holder<WreckerVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    public void setVariant(Holder<WreckerVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)FOTItems.WRECKER_BUCKET);
    }

    protected SoundEvent getDeathSound() {
        return FOTSoundEvents.WRECKER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return FOTSoundEvents.WRECKER_HURT;
    }

    protected SoundEvent getFlopSound() {
        return FOTSoundEvents.WRECKER_FLOP;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isTrophy() ? super.getDefaultDimensions(pose).withEyeHeight(0.34f) : EntityDimensions.fixed((float)0.275f, (float)0.25f).withEyeHeight(0.175f);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (this.isTrophy()) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(2.5);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(2.5);
        }
        super.setTrophy(trophy);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return EARTHWORMS_FOOD.test(itemStack);
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        boolean isWater = level.getFluidState(blockPos).is(FluidTags.WATER) && level.getBlockState(blockPos).is(Blocks.WATER);
        return isWater && TerrainUtils.isInFeature(level.getLevel(), blockPos, FOTTags.Structures.WRECKERS_SPAWN_IN);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.FOLLOW_RANGE, 10.0).add(Attributes.ATTACK_DAMAGE, 1.5).add(Attributes.ATTACK_KNOCKBACK, 0.01);
    }

    @Nullable
    public static BlockPos getNearestShipwreckOrRuinedPortalPos(ServerLevel level, BlockPos pos, ChunkPos chunkPos) {
        Registry structureRegistry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        Optional structureHolderSet = structureRegistry.getTag(FOTTags.Structures.WRECKERS_LOCATED);
        int structureRange = 32;
        int distFromStructure = Integer.MAX_VALUE;
        if (structureHolderSet.isPresent()) {
            Structure structure1 = null;
            ChunkPos chunkPos1 = null;
            for (Holder structureHolder : (HolderSet.Named)structureHolderSet.get()) {
                Structure structure = (Structure)structureHolder.value();
                Map structureRefMap = level.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.STRUCTURE_STARTS).getAllReferences();
                Optional<Structure> optional = structureRefMap.keySet().stream().filter(structurex -> structurex.equals(structure)).findAny();
                if (!optional.isPresent()) continue;
                structure1 = optional.get();
                chunkPos1 = chunkPos;
            }
            if (structure1 != null) {
                for (StructureStart structureStart : level.structureManager().startsForStructure(SectionPos.of(chunkPos1, (int)0), structure1)) {
                    Optional<BlockPos> structureCenter = structureStart.getPieces().stream().map(structurePiece -> structurePiece.getBoundingBox().getCenter()).findAny();
                    if (!structureCenter.isPresent()) continue;
                    int range = structureCenter.get().distManhattan((Vec3i)pos);
                    if (range < distFromStructure) {
                        distFromStructure = range;
                    }
                    if (distFromStructure >= structureRange) continue;
                    return structureCenter.get();
                }
            }
        }
        return null;
    }
}

