/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.sensing;

import com.stevekung.fishofthieves.entity.animal.Wrecker;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class NearestWreckerLocatedSensor
extends Sensor<LivingEntity> {
    public NearestWreckerLocatedSensor() {
        super(20);
    }

    public Set<MemoryModuleType<?>> requires() {
        return Set.of(FOTMemoryModuleTypes.NEAREST_WRECKER_LOCATED);
    }

    protected void doTick(ServerLevel level, LivingEntity entity) {
        double distance;
        BlockPos wreckagePos = Wrecker.getNearestShipwreckOrRuinedPortalPos(level, entity.blockPosition(), entity.chunkPosition());
        if (wreckagePos != null && (distance = entity.distanceToSqr((double)wreckagePos.getX(), entity.getY(), (double)wreckagePos.getZ())) < 1024.0) {
            entity.getBrain().setMemory(FOTMemoryModuleTypes.NEAREST_WRECKER_LOCATED, (Object)wreckagePos);
        }
    }
}

