/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.sensing;

import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MagmaBlockSensor
extends Sensor<LivingEntity> {
    public Set<MemoryModuleType<?>> requires() {
        return Set.of(MemoryModuleType.NEAREST_REPELLENT);
    }

    protected void doTick(ServerLevel level, LivingEntity entity) {
        Brain brain = entity.getBrain();
        brain.setMemory(MemoryModuleType.NEAREST_REPELLENT, MagmaBlockSensor.findNearestRepellent(level, entity));
    }

    private static Optional<BlockPos> findNearestRepellent(ServerLevel level, LivingEntity livingEntity) {
        return BlockPos.findClosestMatch((BlockPos)livingEntity.blockPosition(), (int)10, (int)10, blockPos -> MagmaBlockSensor.isValidRepellent(level, blockPos));
    }

    private static boolean isValidRepellent(ServerLevel level, BlockPos blockPos) {
        BlockState blockState = level.getBlockState(blockPos);
        boolean isRepellent = blockState.is(FOTTags.Blocks.FISH_REPELLENTS);
        return isRepellent && blockState.is(Blocks.BUBBLE_COLUMN) ? (Boolean)blockState.getValue((Property)BubbleColumnBlock.DRAG_DOWN) : isRepellent;
    }
}

