/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.sensing;

import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class LowBrightnessSensor
extends Sensor<LivingEntity> {
    public Set<MemoryModuleType<?>> requires() {
        return Set.of(FOTMemoryModuleTypes.NEAREST_LOW_BRIGHTNESS);
    }

    protected void doTick(ServerLevel level, LivingEntity entity) {
        Brain brain = entity.getBrain();
        brain.setMemory(FOTMemoryModuleTypes.NEAREST_LOW_BRIGHTNESS, LowBrightnessSensor.findNearestLowLight(level, entity));
    }

    private static Optional<BlockPos> findNearestLowLight(ServerLevel level, LivingEntity livingEntity) {
        return BlockPos.findClosestMatch((BlockPos)livingEntity.blockPosition(), (int)8, (int)8, blockPos -> LowBrightnessSensor.isLowLight(level, blockPos));
    }

    private static boolean isLowLight(ServerLevel level, BlockPos blockPos) {
        return level.getFluidState(blockPos).is(FluidTags.WATER) && level.getRawBrightness(blockPos, 0) <= 5;
    }
}

