/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class MergeOtherFlock
extends Behavior<AbstractFlockFish> {
    private static final Predicate<AbstractFlockFish> NOT_MERGE_FROM_OTHER_FLOCK = follower -> !follower.getBrain().hasMemoryValue(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK);
    private static final Predicate<AbstractFlockFish> IS_FLOCK_LEADER = AbstractFlockFish::isLeader;

    public MergeOtherFlock() {
        super(Map.of(FOTMemoryModuleTypes.NEAREST_VISIBLE_FLOCK_LEADER, MemoryStatus.VALUE_PRESENT, FOTMemoryModuleTypes.SCHOOL_SIZE, MemoryStatus.REGISTERED, FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK, MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, AbstractFlockFish owner) {
        Optional<AbstractFlockFish> nearestLeaderOptional = this.getNearestLeader(owner);
        if (nearestLeaderOptional.isPresent()) {
            AbstractFlockFish nearestLeader = nearestLeaderOptional.get();
            if (!owner.isTrophy() && nearestLeader.isTrophy()) {
                return false;
            }
            if (!owner.isTrophy() && !nearestLeader.isTrophy()) {
                return true;
            }
        }
        return true;
    }

    protected void start(ServerLevel level, AbstractFlockFish owner, long gameTime) {
        Brain brain = owner.getBrain();
        boolean mergedFromOtherFlock = brain.hasMemoryValue(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK) && (Boolean)brain.getMemory(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK).get() != false;
        Optional<AbstractFlockFish> nearestLeaderOptional = this.getNearestLeader(owner);
        if (owner.isLeader() && !mergedFromOtherFlock && nearestLeaderOptional.isPresent()) {
            AbstractFlockFish nearestLeader = nearestLeaderOptional.get();
            Integer thisSchoolSize = (Integer)brain.getMemory(FOTMemoryModuleTypes.SCHOOL_SIZE).get();
            Integer otherSchoolSize = (Integer)nearestLeader.getBrain().getMemory(FOTMemoryModuleTypes.SCHOOL_SIZE).get();
            int combinedSchoolSize = thisSchoolSize + otherSchoolSize;
            if (combinedSchoolSize <= owner.getMaxSchoolSize()) {
                Optional flockFollowersFromOtherLeader = nearestLeader.getBrain().getMemory(FOTMemoryModuleTypes.FLOCK_FOLLOWERS);
                flockFollowersFromOtherLeader.ifPresent(list -> list.stream().filter(NOT_MERGE_FROM_OTHER_FLOCK).forEach(follower -> {
                    follower.getBrain().setMemory(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK, (Object)true);
                    follower.getBrain().setMemory(FOTMemoryModuleTypes.FLOCK_LEADER, (Object)owner);
                    owner.addFollower();
                    ((List)brain.getMemory(FOTMemoryModuleTypes.FLOCK_FOLLOWERS).get()).add(follower);
                }));
                nearestLeader.getBrain().setMemory(FOTMemoryModuleTypes.SCHOOL_SIZE, (Object)1);
                nearestLeader.getBrain().setMemory(FOTMemoryModuleTypes.FLOCK_LEADER, (Object)owner);
                nearestLeader.getBrain().setMemory(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER, (Object)true);
                nearestLeader.getBrain().setMemory(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK, (Object)true);
                owner.addFollower();
                ((List)brain.getMemory(FOTMemoryModuleTypes.FLOCK_FOLLOWERS).get()).add(nearestLeader);
                nearestLeader.getBrain().eraseMemory(FOTMemoryModuleTypes.IS_FLOCK_LEADER);
            }
        }
    }

    private Optional<AbstractFlockFish> getNearestLeader(AbstractFlockFish owner) {
        Brain brain = owner.getBrain();
        Optional optional = brain.getMemory(FOTMemoryModuleTypes.NEAREST_VISIBLE_FLOCK_LEADER);
        return ((List)optional.get()).stream().filter(fish -> fish != owner).filter(owner::isSameType).filter(IS_FLOCK_LEADER.and(arg_0 -> ((AbstractFlockFish)owner).hasLineOfSight(arg_0)).and(NOT_MERGE_FROM_OTHER_FLOCK)).findAny();
    }
}

