/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.Map;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;

public class GoToLowBrightness
extends Behavior<LivingEntity> {
    private final float speedModifier;
    private final int closeEnoughDistance;

    public GoToLowBrightness(float speedModifier, int closeEnoughDistance) {
        super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, FOTMemoryModuleTypes.NEAREST_LOW_BRIGHTNESS, MemoryStatus.VALUE_PRESENT));
        this.speedModifier = speedModifier;
        this.closeEnoughDistance = closeEnoughDistance;
    }

    protected void start(ServerLevel level, LivingEntity entity, long gameTime) {
        Brain brain = entity.getBrain();
        if (brain.hasMemoryValue(FOTMemoryModuleTypes.NEAREST_LOW_BRIGHTNESS)) {
            brain.getMemory(FOTMemoryModuleTypes.NEAREST_LOW_BRIGHTNESS).ifPresent(blockPos -> entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(Vec3.atCenterOf((Vec3i)blockPos), this.speedModifier, this.closeEnoughDistance)));
        }
    }
}

