/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.stevekung.fishofthieves.registry.FOTCriteriaTriggers;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class FollowLivingWithEffect
extends Behavior<PathfinderMob> {
    private final Function<LivingEntity, Float> speedModifier;
    private final Function<LivingEntity, Double> closeEnoughDistance;
    private final Function<LivingEntity, Predicate<LivingEntity>> hasEffectPredicate;

    public FollowLivingWithEffect(Function<LivingEntity, Float> speedModifier, Function<LivingEntity, Predicate<LivingEntity>> hasEffectPredicate) {
        this(speedModifier, livingEntity -> 2.5, hasEffectPredicate);
    }

    public FollowLivingWithEffect(Function<LivingEntity, Float> speedModifier, Function<LivingEntity, Double> closeEnoughDistance, Function<LivingEntity, Predicate<LivingEntity>> hasEffectPredicate) {
        super(Map.of(MemoryModuleType.LOOK_TARGET, MemoryStatus.REGISTERED, MemoryModuleType.WALK_TARGET, MemoryStatus.REGISTERED, FOTMemoryModuleTypes.FOLLOW_WITH_EFFECT_COOLDOWN_TICKS, MemoryStatus.VALUE_ABSENT, FOTMemoryModuleTypes.IS_EFFECT_FOLLOWER, MemoryStatus.REGISTERED, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryStatus.VALUE_PRESENT, MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.closeEnoughDistance = closeEnoughDistance;
        this.hasEffectPredicate = hasEffectPredicate;
    }

    protected float getSpeedModifier(PathfinderMob pathfinder) {
        return this.speedModifier.apply((LivingEntity)pathfinder).floatValue();
    }

    private Optional<NearestVisibleLivingEntities> getLivingEntitiesHasEffect(PathfinderMob pathfinder) {
        return pathfinder.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }

    protected boolean canStillUse(ServerLevel level, PathfinderMob entity, long gameTime) {
        return this.getLivingEntitiesHasEffect(entity).isPresent() && !entity.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
    }

    protected void start(ServerLevel level, PathfinderMob entity, long gameTime) {
        entity.getBrain().setMemory(FOTMemoryModuleTypes.IS_EFFECT_FOLLOWER, (Object)true);
    }

    protected void stop(ServerLevel level, PathfinderMob entity, long gameTime) {
        Brain brain = entity.getBrain();
        brain.setMemory(FOTMemoryModuleTypes.FOLLOW_WITH_EFFECT_COOLDOWN_TICKS, (Object)100);
        brain.setMemory(FOTMemoryModuleTypes.IS_EFFECT_FOLLOWER, (Object)false);
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    protected void tick(ServerLevel level, PathfinderMob owner, long gameTime) {
        Optional optionalPlayer = this.getLivingEntitiesHasEffect(owner).get().findClosest(this.hasEffectPredicate.apply((LivingEntity)owner));
        if (optionalPlayer.isPresent()) {
            LivingEntity player = (LivingEntity)optionalPlayer.get();
            Brain brain = owner.getBrain();
            brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)player, true));
            Double distance = this.closeEnoughDistance.apply((LivingEntity)owner);
            if (owner.distanceToSqr((Entity)player) < Mth.square((double)distance)) {
                brain.eraseMemory(MemoryModuleType.WALK_TARGET);
            } else {
                brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)player, false), this.getSpeedModifier(owner), 2));
            }
            if (gameTime % 80L == 0L && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                FOTCriteriaTriggers.FOLLOW_LIVING_WITH_EFFECT.trigger(serverPlayer, (Entity)owner);
            }
        }
    }
}

